/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.mql;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.Interpreter;
import com.googlecode.mjorm.mql.InterpreterImpl;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlVariableFunction;
import com.googlecode.mjorm.mql.functions.DateVariableFunction;
import com.googlecode.mjorm.mql.functions.NowVariableFunction;
import com.googlecode.mjorm.mql.functions.ObjectIdVariableFunction;
import com.googlecode.mjorm.query.QueryGroup;
import com.googlecode.mjorm.query.criteria.BetweenCriterion;
import com.googlecode.mjorm.query.criteria.ElemMatchCriterion;
import com.googlecode.mjorm.query.criteria.ExistsCriterion;
import com.googlecode.mjorm.query.criteria.ModCriterion;
import com.googlecode.mjorm.query.criteria.NearCriterion;
import com.googlecode.mjorm.query.criteria.SimpleCriterion;
import com.googlecode.mjorm.query.criteria.SizeCriterion;
import com.googlecode.mjorm.query.criteria.TypeCriterion;
import com.googlecode.mjorm.query.criteria.WithinBoxCriterion;
import com.googlecode.mjorm.query.criteria.WithinCircleCriterion;
import com.googlecode.mjorm.query.criteria.WithinPolygonCriterion;
import com.mongodb.DB;
import java.util.HashMap;
import java.util.Map;

public class InterpreterFactory {
    private static InterpreterFactory DEFAULT_INSTANCE = null;
    private Map<String, MqlCriterionFunction> documentFunctions = new HashMap<String, MqlCriterionFunction>();
    private Map<String, MqlCriterionFunction> fieldFunctions = new HashMap<String, MqlCriterionFunction>();
    private Map<String, MqlVariableFunction> variableFunctions = new HashMap<String, MqlVariableFunction>();

    public static InterpreterFactory getDefaultInstance() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = InterpreterFactory.newInstance();
            DEFAULT_INSTANCE.registerDefaultFunctions();
        }
        return DEFAULT_INSTANCE;
    }

    public static InterpreterFactory newInstance() {
        return new InterpreterFactory();
    }

    public Interpreter create(DB db, ObjectMapper objectMapper) {
        InterpreterImpl ret = new InterpreterImpl(db, objectMapper);
        for (Map.Entry<String, MqlCriterionFunction> entry : this.documentFunctions.entrySet()) {
            ret.registerDocumentFunction(entry.getValue());
        }
        for (Map.Entry<String, MqlCriterionFunction> entry : this.fieldFunctions.entrySet()) {
            ret.registerFieldFunction(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.variableFunctions.entrySet()) {
            ret.registerVariableFunction((MqlVariableFunction)entry.getValue());
        }
        return ret;
    }

    public void clearFieldFunctions() {
        this.fieldFunctions.clear();
    }

    public void clearDocumentFunctions() {
        this.documentFunctions.clear();
    }

    public void clearVariableFunctions() {
        this.variableFunctions.clear();
    }

    public void clearFunctions() {
        this.clearFieldFunctions();
        this.clearDocumentFunctions();
        this.clearVariableFunctions();
    }

    public void removeDocumentFunction(String name) {
        this.documentFunctions.remove(name.trim().toLowerCase());
    }

    public void removeFieldFunction(String name) {
        this.fieldFunctions.remove(name.trim().toLowerCase());
    }

    public void removeVariableFunction(String name) {
        this.variableFunctions.remove(name.trim().toLowerCase());
    }

    public void registerFieldFunction(MqlCriterionFunction function) {
        this.fieldFunctions.put(function.getName().trim().toLowerCase(), function);
    }

    public void registerDocumentFunction(MqlCriterionFunction function) {
        this.documentFunctions.put(function.getName().trim().toLowerCase(), function);
    }

    public void registerVariableFunction(MqlVariableFunction function) {
        this.variableFunctions.put(function.getName().trim().toLowerCase(), function);
    }

    public void registerDefaultFunctions() {
        this.registerFieldFunction(ExistsCriterion.createFunction("exists"));
        this.registerFieldFunction(ExistsCriterion.createNegatedFunction("not_exists"));
        this.registerFieldFunction(BetweenCriterion.createFunction("between"));
        this.registerFieldFunction(ElemMatchCriterion.createFunction("elemMatch"));
        this.registerFieldFunction(ModCriterion.createFunction("mod"));
        this.registerFieldFunction(SizeCriterion.createFunction("size"));
        this.registerFieldFunction(NearCriterion.createFunction("near"));
        this.registerFieldFunction(WithinBoxCriterion.createFunction("within_box"));
        this.registerFieldFunction(WithinCircleCriterion.createFunction("within_circle"));
        this.registerFieldFunction(WithinPolygonCriterion.createFunction("within_polygon"));
        this.registerFieldFunction(TypeCriterion.createFunction("type"));
        this.registerFieldFunction(SimpleCriterion.createForOperator("in", SimpleCriterion.Operator.IN, 1, Integer.MAX_VALUE, -1, new Class[0]));
        this.registerFieldFunction(SimpleCriterion.createForOperator("nin", SimpleCriterion.Operator.NIN, 1, Integer.MAX_VALUE, -1, new Class[0]));
        this.registerFieldFunction(SimpleCriterion.createForOperator("all", SimpleCriterion.Operator.ALL, 1, Integer.MAX_VALUE, -1, new Class[0]));
        this.registerDocumentFunction(QueryGroup.createMqlDocumentFunction("or", "$or", true, true));
        this.registerDocumentFunction(QueryGroup.createMqlDocumentFunction("nor", "$nor", true, true));
        this.registerDocumentFunction(QueryGroup.createMqlDocumentFunction("and", "$and", true, true));
        this.registerDocumentFunction(QueryGroup.createMqlDocumentFunction("predicate", "$where", 1, new Class[0]));
        this.registerVariableFunction(DateVariableFunction.INSTANCE);
        this.registerVariableFunction(NowVariableFunction.INSTANCE);
        this.registerVariableFunction(ObjectIdVariableFunction.INSTANCE);
    }
}

