/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query;

import com.googlecode.mjorm.ObjectIterator;
import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.query.DaoModifier;
import com.googlecode.mjorm.query.criteria.AbstractQueryCriterion;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoQuery
extends AbstractQueryCriterion<DaoQuery> {
    private DB db;
    private ObjectMapper objectMapper;
    private Map<String, Integer> sort;
    private Map<String, Object> specials;
    private Integer firstDocument;
    private Integer maxDocuments;
    private Integer batchSize;
    private DBObject hint;
    private Boolean snapShot;
    private String comment;
    private String collection;
    private ReadPreference readPreference;
    private CursorVisitor cursorVisitor;
    private DaoModifier modifier;

    public DaoQuery() {
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        if (this.modifier != null) {
            this.modifier.clear();
        }
        this.sort = new HashMap<String, Integer>();
        this.specials = new HashMap<String, Object>();
        this.firstDocument = null;
        this.maxDocuments = null;
        this.batchSize = null;
        this.hint = null;
        this.snapShot = null;
        this.comment = null;
        this.collection = null;
        this.cursorVisitor = null;
        this.modifier = null;
    }

    public void assertValid() {
        if (this.collection == null) {
            throw new IllegalStateException("collection must be specified");
        }
        if (this.db == null) {
            throw new IllegalStateException("DB must be specified");
        }
    }

    public DaoModifier modify() {
        if (this.modifier == null) {
            this.modifier = new DaoModifier(this);
        }
        return this.modifier;
    }

    public <T> ObjectIterator<T> findObjects(Class<T> clazz) {
        this.assertValid();
        DBCursor cursor = this.db.getCollection(this.collection).find(this.toQueryObject(this.objectMapper));
        this.setupCursor(cursor);
        return new ObjectIterator<T>(cursor, this.objectMapper, clazz);
    }

    public DBCursor findObjects(DBObject fields) {
        this.assertValid();
        DBCursor cursor = this.db.getCollection(this.collection).find(this.toQueryObject(this.objectMapper), fields);
        this.setupCursor(cursor);
        return cursor;
    }

    public DBCursor findObjects() {
        this.assertValid();
        DBCursor cursor = this.db.getCollection(this.collection).find(this.toQueryObject(this.objectMapper));
        this.setupCursor(cursor);
        return cursor;
    }

    public DBCursor findObjects(String ... fields) {
        BasicDBObject dbObject = new BasicDBObject();
        for (String field : fields) {
            dbObject.put(field, (Object)1);
        }
        return this.findObjects((DBObject)dbObject);
    }

    public <T> T findObject(Class<T> clazz) {
        this.assertValid();
        ObjectIterator<T> itr = this.findObjects(clazz);
        return itr.hasNext() ? (T)itr.next() : null;
    }

    public DBObject findObject(DBObject fields) {
        this.assertValid();
        DBCursor itr = this.findObjects(fields);
        return itr.hasNext() ? itr.next() : null;
    }

    public DBObject findObject() {
        this.assertValid();
        DBCursor itr = this.findObjects();
        return itr.hasNext() ? itr.next() : null;
    }

    public long countObjects() {
        this.assertValid();
        return this.readPreference != null ? this.db.getCollection(this.collection).count(this.toQueryObject(this.objectMapper), this.readPreference) : this.db.getCollection(this.collection).count(this.toQueryObject(this.objectMapper));
    }

    public List<Object> distinct(String field) {
        this.assertValid();
        DBCollection col = this.db.getCollection(this.collection);
        return this.readPreference != null ? col.distinct(field, this.toQueryObject(this.objectMapper), this.readPreference) : col.distinct(field, this.toQueryObject(this.objectMapper));
    }

    public <T> List<T> distinct(String field, Class<T> expected) {
        this.assertValid();
        return this.distinct(field);
    }

    public DBObject explain() {
        this.assertValid();
        DBCursor cursor = this.db.getCollection(this.collection).find(this.toQueryObject(this.objectMapper));
        this.setupCursor(cursor);
        return cursor.explain();
    }

    private void setupCursor(DBCursor cursor) {
        if (this.readPreference != null) {
            cursor.setReadPreference(this.readPreference);
        }
        if (this.firstDocument != null) {
            cursor.skip(this.firstDocument.intValue());
        }
        if (this.maxDocuments != null) {
            cursor.limit(this.maxDocuments.intValue());
        }
        if (this.batchSize != null) {
            cursor.batchSize(this.batchSize.intValue());
        }
        if (this.hint != null) {
            cursor.hint(this.hint);
        }
        if (this.snapShot != null && this.snapShot.booleanValue()) {
            cursor.snapshot();
        }
        if (this.comment != null) {
            cursor.addSpecial("$comment", (Object)this.comment);
        }
        if (!this.specials.isEmpty()) {
            for (Map.Entry<String, Object> special : this.specials.entrySet()) {
                cursor.addSpecial(special.getKey(), special.getValue());
            }
        }
        if (!this.sort.isEmpty()) {
            cursor.sort(this.getSortDBObject());
        }
        if (this.cursorVisitor != null) {
            this.cursorVisitor.visit(cursor);
        }
    }

    public DBObject getSortDBObject() {
        BasicDBObject sortObj = new BasicDBObject();
        if (!this.sort.isEmpty()) {
            for (Map.Entry<String, Integer> entry : this.sort.entrySet()) {
                sortObj.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        return sortObj;
    }

    @Override
    protected DaoQuery self() {
        return this;
    }

    public DaoQuery addSort(String name, Integer direction) {
        this.sort.put(name, direction);
        return this.self();
    }

    public DaoQuery addSpecial(String name, Object special) {
        this.specials.put(name, special);
        return this.self();
    }

    public DaoQuery setSort(Map<String, Integer> sort) {
        this.sort = sort;
        return this.self();
    }

    public DaoQuery setSort(DBObject sort) {
        this.sort.clear();
        this.sort.putAll(sort.toMap());
        return this.self();
    }

    public void setSpecials(Map<String, Object> specials) {
        this.specials = specials;
    }

    public DaoQuery setFirstDocument(Integer firstDocument) {
        this.firstDocument = firstDocument;
        return this.self();
    }

    public DaoQuery setMaxDocuments(Integer maxDocuments) {
        this.maxDocuments = maxDocuments;
        return this.self();
    }

    public DaoQuery setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this.self();
    }

    public DaoQuery setHint(String hint, int dir) {
        this.hint = new BasicDBObject(hint, (Object)dir);
        return this.self();
    }

    public DaoQuery setHint(DBObject hint) {
        this.hint = hint;
        return this.self();
    }

    public DaoQuery setSnapShot(Boolean snapShot) {
        this.snapShot = snapShot;
        return this.self();
    }

    public DaoQuery setSnapShot() {
        this.setSnapShot(true);
        return this.self();
    }

    public DaoQuery setComment(String comment) {
        this.comment = comment;
        return this.self();
    }

    public DaoQuery setCollection(String collection) {
        this.collection = collection;
        return this.self();
    }

    public DaoQuery setDB(DB db) {
        this.db = db;
        return this.self();
    }

    public DaoQuery setCursorVisitor(CursorVisitor cursorVisitor) {
        this.cursorVisitor = cursorVisitor;
        return this.self();
    }

    public DaoQuery setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this.self();
    }

    public DaoQuery setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this.self();
    }

    public String getCollection() {
        return this.collection;
    }

    public DB getDB() {
        return this.db;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static interface CursorVisitor {
        public void visit(DBCursor var1);
    }
}

