/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.query.Query;
import com.googlecode.mjorm.query.QueryGroup;
import com.googlecode.mjorm.query.criteria.BetweenCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.googlecode.mjorm.query.criteria.ElemMatchCriterion;
import com.googlecode.mjorm.query.criteria.EqualsCriterion;
import com.googlecode.mjorm.query.criteria.ExistsCriterion;
import com.googlecode.mjorm.query.criteria.FieldCriterion;
import com.googlecode.mjorm.query.criteria.ModCriterion;
import com.googlecode.mjorm.query.criteria.NearCriterion;
import com.googlecode.mjorm.query.criteria.NotCriterion;
import com.googlecode.mjorm.query.criteria.RegexCriterion;
import com.googlecode.mjorm.query.criteria.SimpleCriterion;
import com.googlecode.mjorm.query.criteria.SizeCriterion;
import com.googlecode.mjorm.query.criteria.TypeCriterion;
import com.googlecode.mjorm.query.criteria.WithinBoxCriterion;
import com.googlecode.mjorm.query.criteria.WithinCircleCriterion;
import com.googlecode.mjorm.query.criteria.WithinPolygonCriterion;
import java.util.Collection;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criteria {
    public static <V> EqualsCriterion eq(V value) {
        return new EqualsCriterion(value);
    }

    public static <V> SimpleCriterion gt(V value) {
        return new SimpleCriterion(SimpleCriterion.Operator.GT, value);
    }

    public static <V> SimpleCriterion gte(V value) {
        return new SimpleCriterion(SimpleCriterion.Operator.GTE, value);
    }

    public static <V> SimpleCriterion lt(V value) {
        return new SimpleCriterion(SimpleCriterion.Operator.LT, value);
    }

    public static <V> SimpleCriterion lte(V value) {
        return new SimpleCriterion(SimpleCriterion.Operator.LTE, value);
    }

    public static <V> BetweenCriterion between(V left, V right) {
        return new BetweenCriterion(left, right);
    }

    public static <V> SimpleCriterion ne(V value) {
        return new SimpleCriterion(SimpleCriterion.Operator.NE, value);
    }

    public static <V> SimpleCriterion in(V ... values) {
        return new SimpleCriterion(SimpleCriterion.Operator.IN, values);
    }

    public static <V> SimpleCriterion in(Collection<V> values) {
        return new SimpleCriterion(SimpleCriterion.Operator.IN, values);
    }

    public static <V> SimpleCriterion nin(V ... values) {
        return new SimpleCriterion(SimpleCriterion.Operator.NIN, values);
    }

    public static <V> SimpleCriterion nin(Collection<V> values) {
        return new SimpleCriterion(SimpleCriterion.Operator.NIN, values);
    }

    public static <V> SimpleCriterion all(V ... values) {
        return new SimpleCriterion(SimpleCriterion.Operator.ALL, values);
    }

    public static <V> SimpleCriterion all(Collection<V> values) {
        return new SimpleCriterion(SimpleCriterion.Operator.ALL, values);
    }

    public static ExistsCriterion exists(Boolean value) {
        return new ExistsCriterion(value);
    }

    public static ModCriterion mod(Number left, Number right) {
        return new ModCriterion(left, right);
    }

    public static RegexCriterion regex(Pattern pattern) {
        return new RegexCriterion(pattern);
    }

    public static RegexCriterion regex(String pattern) {
        return new RegexCriterion(pattern);
    }

    public static RegexCriterion regex(String pattern, int flags) {
        return new RegexCriterion(pattern, flags);
    }

    public static SizeCriterion size(Number size) {
        return new SizeCriterion(size);
    }

    public static NearCriterion near(Number x, Number y, Number distance) {
        return new NearCriterion(x, y, distance);
    }

    public static NearCriterion near(Number x, Number y) {
        return new NearCriterion(x, y);
    }

    public static WithinBoxCriterion within(Number x, Number y, Number xx, Number yy) {
        return new WithinBoxCriterion(x, y, xx, yy);
    }

    public static WithinCircleCriterion within(Number x, Number y, Number radius) {
        return new WithinCircleCriterion(x, y, radius);
    }

    public static WithinPolygonCriterion within(Number[][] points) {
        return new WithinPolygonCriterion(points);
    }

    public static TypeCriterion type(Number typeCode) {
        return new TypeCriterion(typeCode);
    }

    public static TypeCriterion type(TypeCriterion.Type type) {
        return new TypeCriterion(type);
    }

    public static ElemMatchCriterion elemMatch() {
        return new ElemMatchCriterion();
    }

    public static ElemMatchCriterion elemMatch(Query queryCriterion) {
        return new ElemMatchCriterion(queryCriterion);
    }

    public static QueryGroup group() {
        return new QueryGroup();
    }

    public static QueryGroup group(Query ... queries) {
        QueryGroup ret = new QueryGroup();
        for (Query queryCriterion : queries) {
            ret.add(queryCriterion);
        }
        return ret;
    }

    public static NotCriterion not(FieldCriterion criteria) {
        return new NotCriterion(criteria);
    }

    public static NotCriterion not(String fieldName, Criterion criteria) {
        return new NotCriterion(fieldName, criteria);
    }
}

