/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.AbstractMqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.mongodb.BasicDBObject;

public class ExistsCriterion
extends AbstractCriterion {
    private Boolean value;

    public ExistsCriterion(Boolean value) {
        this.value = value;
    }

    public Boolean getValue() {
        return this.value;
    }

    public Object toQueryObject(ObjectMapper mapper) {
        return new BasicDBObject("$exists", (Object)this.value);
    }

    public static MqlCriterionFunction createFunction(final String functionName) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setMinArgs(1);
                this.setMaxArgs(1);
                this.setTypes(Boolean.class);
            }

            protected Criterion doCreate(Object[] values) {
                Boolean arg = values.length > 0 ? (Boolean)Boolean.class.cast(values[0]) : true;
                return new ExistsCriterion(arg);
            }

            protected Criterion doCreate() {
                return new ExistsCriterion(true);
            }
        };
    }

    public static MqlCriterionFunction createNegatedFunction(final String functionName) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setMinArgs(1);
                this.setMaxArgs(1);
                this.setTypes(Boolean.class);
            }

            protected Criterion doCreate(Object[] values) {
                Boolean arg = values.length > 0 ? (Boolean)Boolean.class.cast(values[0]) : false;
                return new ExistsCriterion(arg);
            }

            protected Criterion doCreate() {
                return new ExistsCriterion(false);
            }
        };
    }
}

