/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.AbstractMqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.mongodb.BasicDBObject;

public class NearCriterion
extends AbstractCriterion {
    private Number[] coords = new Number[2];
    private Number distance;

    public NearCriterion(Number x, Number y, Number distance) {
        this.coords[0] = x;
        this.coords[1] = y;
        this.distance = distance;
    }

    public NearCriterion(Number x, Number y) {
        this(x, y, null);
    }

    public Number getX() {
        return this.coords[0];
    }

    public Number getY() {
        return this.coords[1];
    }

    public Number getDistance() {
        return this.distance;
    }

    public Object toQueryObject(ObjectMapper mapper) {
        BasicDBObject ret = new BasicDBObject();
        ret.put("$near", (Object)this.coords);
        if (this.distance != null) {
            ret.put("$maxDistance", (Object)this.distance);
        }
        return ret;
    }

    public static MqlCriterionFunction createFunction(final String functionName) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setMinArgs(2);
                this.setMaxArgs(3);
                this.setTypes(Number.class);
            }

            protected Criterion doCreate(Object[] values) {
                return values.length == 3 ? new NearCriterion((Number)Number.class.cast(values[0]), (Number)Number.class.cast(values[1]), (Number)Number.class.cast(values[2])) : new NearCriterion((Number)Number.class.cast(values[0]), (Number)Number.class.cast(values[1]));
            }
        };
    }
}

