/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.AbstractMqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.mongodb.BasicDBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCriterion
extends AbstractCriterion {
    private String operator;
    private Object value;

    public SimpleCriterion(String operator, Object value) {
        this.operator = operator;
        this.value = value;
    }

    public SimpleCriterion(Operator operator, Object value) {
        this(operator.getOperatorString(), value);
    }

    public String getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object toQueryObject(ObjectMapper mapper) {
        return new BasicDBObject(this.operator, mapper.unmapValue(this.value));
    }

    public static final MqlCriterionFunction createForOperator(final String functionName, final Operator operator, final int minArgs, final int maxArgs, final int exactArgs, final Class<?> ... types) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setMinArgs(minArgs);
                this.setMaxArgs(maxArgs);
                this.setExactArgs(exactArgs);
                this.setTypes(types);
            }

            public Criterion createForArguments(Object[] values) {
                return new SimpleCriterion(operator, (Object)values);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        GT("$gt"),
        GTE("$gte"),
        LT("$lt"),
        LTE("$lte"),
        NE("$ne"),
        IN("$in"),
        NIN("$nin"),
        ALL("$all");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperatorString() {
            return this.operator;
        }
    }
}

