/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.AbstractMqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.mongodb.BasicDBObject;

public class TypeCriterion
extends AbstractCriterion {
    private Number typeCode;

    public TypeCriterion(Number typeCode) {
        this.typeCode = typeCode;
    }

    public TypeCriterion(Type type) {
        this(type.getCode());
    }

    public Number getTypeCode() {
        return this.typeCode;
    }

    public Object toQueryObject(ObjectMapper mapper) {
        return new BasicDBObject("$type", (Object)this.typeCode);
    }

    public static MqlCriterionFunction createFunction(final String functionName) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setExactArgs(1);
                this.setTypes(Number.class);
            }

            protected Criterion doCreate(Object[] values) {
                return new TypeCriterion((Number)Number.class.cast(values[0]));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DOUBLE(1),
        STRING(2),
        OBJECT(3),
        ARRAY(4),
        BINARY(5),
        OBJECT_ID(7),
        BOOLEAN(8),
        DATE(9),
        NULL(10),
        REGEX(11),
        JAVASCRIPT(13),
        SYMBOL(14),
        JAVASCRIPT_WITH_SCOPE(15),
        INT32(16),
        TIMESTAMP(17),
        INT64(18),
        MIN_KEY(255),
        MAX_KEY(127);

        private Number code;

        private Type(Number code) {
            this.code = code;
        }

        public Number getCode() {
            return this.code;
        }
    }
}

