/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.AbstractMqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.mongodb.BasicDBObject;

public class WithinBoxCriterion
extends AbstractCriterion {
    private Number[][] coords = new Number[2][2];

    public WithinBoxCriterion(Number x, Number y, Number xx, Number yy) {
        this.coords[0][0] = x;
        this.coords[0][1] = y;
        this.coords[1][0] = xx;
        this.coords[1][1] = yy;
    }

    public Number getX() {
        return this.coords[0][0];
    }

    public Number getY() {
        return this.coords[0][1];
    }

    public Number getXX() {
        return this.coords[1][0];
    }

    public Number getYY() {
        return this.coords[1][1];
    }

    public Object toQueryObject(ObjectMapper mapper) {
        return new BasicDBObject("$within", (Object)new BasicDBObject("$box", (Object)this.coords));
    }

    public static MqlCriterionFunction createFunction(final String functionName) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setExactArgs(4);
                this.setTypes(Number.class);
            }

            protected Criterion doCreate(Object[] values) {
                return new WithinBoxCriterion((Number)Number.class.cast(values[0]), (Number)Number.class.cast(values[1]), (Number)Number.class.cast(values[2]), (Number)Number.class.cast(values[2]));
            }
        };
    }
}

