/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.spring;

import com.googlecode.mjorm.XmlDescriptorObjectMapper;
import com.googlecode.mjorm.convert.TypeConverter;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDescriptorObjectMapperFactoryBean
extends AbstractFactoryBean<XmlDescriptorObjectMapper> {
    private List<Resource> xmlResources = new ArrayList<Resource>();
    private List<File> xmlFiles = new ArrayList<File>();
    private List<TypeConverter<?, ?>> typeConverters = new ArrayList();

    protected XmlDescriptorObjectMapper createInstance() throws Exception {
        XmlDescriptorObjectMapper mapper = new XmlDescriptorObjectMapper();
        for (TypeConverter<?, ?> converter : this.typeConverters) {
            mapper.registerTypeConverter(converter);
        }
        for (Resource resource : this.xmlResources) {
            InputStream ips = resource.getInputStream();
            mapper.addXmlObjectDescriptor(ips);
            ips.close();
        }
        for (File file : this.xmlFiles) {
            mapper.addXmlObjectDescriptor(file);
        }
        return mapper;
    }

    public Class<?> getObjectType() {
        return XmlDescriptorObjectMapper.class;
    }

    public void setXmlResources(List<Resource> xmlResources) {
        this.xmlResources = xmlResources;
    }

    public void setXmlFiles(List<File> xmlFiles) {
        this.xmlFiles = xmlFiles;
    }

    public void setTypeConverters(List<TypeConverter<?, ?>> typeConverters) {
        this.typeConverters = typeConverters;
    }
}

