/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.crypto.key.StandardKeyPair;
import com.bitmark.sdk.crypto.libsodium.LibSodium;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;
import jnr.ffi.byref.LongLongByReference;

public class Ed25519 {
    public static final int SEED_LENGTH = 32;
    public static final int PUBLIC_KEY_LENGTH = 32;
    public static final int PRIVATE_KEY_LENGTH = 64;
    public static final int SIG_LENGTH = 64;

    private Ed25519() {
    }

    public static KeyPair generateKeyPair() {
        byte[] publicKey = new byte[32];
        byte[] privateKey = new byte[64];
        LibSodium.sodium().crypto_sign_ed25519_keypair(publicKey, privateKey);
        return StandardKeyPair.from(publicKey, privateKey);
    }

    public static KeyPair generateKeyPairFromSeed(byte[] seed) throws ValidateException.InvalidLength {
        Validator.checkValidLength(seed, 32);
        byte[] publicKey = new byte[32];
        byte[] privateKey = new byte[64];
        LibSodium.sodium().crypto_sign_ed25519_seed_keypair(publicKey, privateKey, seed);
        return StandardKeyPair.from(publicKey, privateKey);
    }

    public static KeyPair getKeyPair(byte[] privateKey) throws ValidateException.InvalidLength {
        Validator.checkValidLength(privateKey, 64);
        byte[] publicKey = new byte[32];
        LibSodium.sodium().crypto_sign_ed25519_sk_to_pk(publicKey, privateKey);
        return StandardKeyPair.from(publicKey, privateKey);
    }

    public static byte[] getSeed(byte[] privateKey) throws ValidateException.InvalidLength {
        Validator.checkValidLength(privateKey, 64);
        byte[] seed = new byte[32];
        LibSodium.sodium().crypto_sign_ed25519_sk_to_seed(seed, privateKey);
        return seed;
    }

    public static String getSeed(String hexPrivateKey) throws ValidateException.InvalidHex {
        Validator.checkValidHex(hexPrivateKey);
        return Hex.HEX.encode(Ed25519.getSeed(Hex.HEX.decode(hexPrivateKey)));
    }

    public static byte[] sign(byte[] message, byte[] privateKey) throws ValidateException.InvalidLength {
        Validator.checkValidLength(privateKey, 64);
        byte[] signature = new byte[64];
        LibSodium.sodium().crypto_sign_ed25519_detached(signature, new LongLongByReference((long)signature.length), message, message.length, privateKey);
        return signature;
    }

    public static String sign(String hexMessage, String hexPrivateKey) throws ValidateException.InvalidHex {
        Validator.checkValidHex(hexMessage);
        Validator.checkValidHex(hexPrivateKey);
        return Hex.HEX.encode(Ed25519.sign(Hex.HEX.decode(hexMessage), Hex.HEX.decode(hexPrivateKey)));
    }

    public static boolean verify(byte[] signature, byte[] message, byte[] publicKey) throws ValidateException.InvalidLength {
        Validator.checkValidLength(publicKey, 32);
        Validator.checkValidLength(signature, 64);
        return LibSodium.sodium().crypto_sign_ed25519_verify_detached(signature, message, message.length, publicKey) == 0;
    }

    public static boolean verify(String hexSignature, String hexMessage, String hexPublicKey) throws ValidateException.InvalidHex {
        Validator.checkValidHex(hexSignature);
        Validator.checkValidHex(hexMessage);
        Validator.checkValidHex(hexPublicKey);
        return Ed25519.verify(Hex.HEX.decode(hexSignature), Hex.HEX.decode(hexMessage), Hex.HEX.decode(hexPublicKey));
    }
}

