/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto;

import com.bitmark.sdk.crypto.libsodium.LibSodium;
import java.security.SecureRandom;

public class Random {
    private Random() {
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        LibSodium.sodium().randombytes(bytes, size);
        return bytes;
    }

    public static byte[] secureRandomBytes(int size) {
        byte[] bytes = new byte[size];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    public static int secureRandomInt() {
        return new SecureRandom().nextInt() & Integer.MAX_VALUE;
    }

    public static int[] secureRandomInts(int size) {
        int[] ints = new int[size];
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < size; ++i) {
            ints[i] = random.nextInt() & Integer.MAX_VALUE;
        }
        return ints;
    }
}

