/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto;

import com.bitmark.sdk.crypto.libsodium.LibSodium;
import java.util.Arrays;

public class SecretBox {
    private SecretBox() {
    }

    public static byte[] generateSecretBox(byte[] msg, byte[] nonce, byte[] key) {
        int msgLength = msg.length;
        byte[] m = new byte[key.length + msgLength];
        byte[] c = new byte[m.length];
        System.arraycopy(msg, 0, m, m.length - msgLength, msgLength);
        LibSodium.sodium().crypto_secretbox(c, m, m.length, nonce, key);
        return Arrays.copyOfRange(c, msgLength, c.length);
    }
}

