/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha256
implements Comparable<Sha256> {
    public static final int HASH_LENGTH = 32;
    private final byte[] bytes;

    private Sha256(byte[] bytes) {
        this.bytes = bytes;
    }

    public static Sha256 from(byte[] bytes) throws ValidateException {
        Validator.checkValidLength(bytes, 32);
        return new Sha256(bytes);
    }

    public static Sha256 from(String hexHash) throws ValidateException {
        Validator.checkValidHex(hexHash);
        return Sha256.from(Hex.HEX.decode(hexHash));
    }

    public static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash(String hexInput) throws ValidateException {
        Validator.checkValidHex(hexInput);
        byte[] rawBytes = Hex.HEX.decode(hexInput);
        return Sha256.hash(rawBytes, 0, rawBytes.length);
    }

    public static byte[] hash(byte[] input) {
        return Sha256.hash(input, 0, input.length);
    }

    public static byte[] hash(byte[] input, int offset, int length) throws ValidateException {
        Validator.checkValid(() -> offset >= 0 && length > 0);
        MessageDigest digest = Sha256.newDigest();
        digest.update(input, offset, length);
        return digest.digest();
    }

    public static byte[] hashTwice(String hexString) throws ValidateException {
        Validator.checkValidHex(hexString);
        return Sha256.hashTwice(Hex.HEX.decode(hexString));
    }

    public static byte[] hashTwice(byte[] input) throws ValidateException {
        return Sha256.hashTwice(input, 0, input.length);
    }

    public static byte[] hashTwice(byte[] input, int offset, int length) throws ValidateException {
        Validator.checkValid(() -> offset >= 0 && length > 0);
        MessageDigest digest = Sha256.newDigest();
        digest.update(input, offset, length);
        return digest.digest(digest.digest());
    }

    public String toString() {
        return Hex.HEX.encode(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int compareTo(Sha256 other) {
        for (int i = 31; i >= 0; --i) {
            int thisByte = this.bytes[i] & 0xFF;
            int otherByte = other.bytes[i] & 0xFF;
            if (thisByte > otherByte) {
                return 1;
            }
            if (thisByte >= otherByte) continue;
            return -1;
        }
        return 0;
    }
}

