/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;
import org.bouncycastle.jcajce.provider.digest.SHA3;

public class Sha3512
implements Comparable<Sha3512> {
    public static final int HASH_LENGTH = 64;
    private final byte[] bytes;

    private Sha3512(byte[] bytes) {
        this.bytes = bytes;
    }

    public static Sha3512 from(byte[] bytes) throws ValidateException {
        Validator.checkValidLength(bytes, 64);
        return new Sha3512(bytes);
    }

    public static Sha3512 from(String hexHash) throws ValidateException {
        Validator.checkValidHex(hexHash);
        return Sha3512.from(Hex.HEX.decode(hexHash));
    }

    public static byte[] hash(byte[] input) throws ValidateException {
        return Sha3512.hash(input, 0, input.length);
    }

    public static byte[] hash(byte[] input, int offset, int length) throws ValidateException {
        Validator.checkValid(() -> offset >= 0 && length > 0);
        SHA3.Digest512 digest = new SHA3.Digest512();
        digest.update(input, offset, length);
        return digest.digest();
    }

    public static byte[] hash(String hexInput) throws ValidateException {
        Validator.checkValidHex(hexInput);
        byte[] input = Hex.HEX.decode(hexInput);
        return Sha3512.hash(input);
    }

    public static byte[] hashTwice(byte[] input) throws ValidateException {
        return Sha3512.hashTwice(input, 0, input.length);
    }

    public static byte[] hashTwice(byte[] input, int offset, int length) throws ValidateException {
        Validator.checkValid(() -> offset >= 0 && length > 0);
        SHA3.Digest512 digest = new SHA3.Digest512();
        digest.update(input, offset, length);
        return digest.digest(digest.digest());
    }

    public static byte[] hashTwice(String hexInput) throws ValidateException {
        Validator.checkValidHex(hexInput);
        byte[] input = Hex.HEX.decode(hexInput);
        return Sha3512.hashTwice(input);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return Hex.HEX.encode(this.bytes);
    }

    @Override
    public int compareTo(Sha3512 other) {
        for (int i = 63; i >= 0; --i) {
            int thisByte = this.bytes[i] & 0xFF;
            int otherByte = other.bytes[i] & 0xFF;
            if (thisByte > otherByte) {
                return 1;
            }
            if (thisByte >= otherByte) continue;
            return -1;
        }
        return 0;
    }
}

