/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto.encoder;

import com.bitmark.sdk.crypto.encoder.Encoder;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;
import java.util.Arrays;

public class Base58
implements Encoder {
    public static final Base58 BASE_58 = new Base58();
    private static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final char ENCODED_ZERO = ALPHABET[0];
    private static final int[] INDEXES = new int[128];

    private Base58() {
    }

    @Override
    public String encode(byte[] input) {
        int zeros;
        Validator.checkValid(() -> input != null && input.length > 0);
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        byte[] bytes = Arrays.copyOf(input, input.length);
        char[] encoded = new char[bytes.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < bytes.length) {
            encoded[--outputStart] = ALPHABET[Base58.divmod(bytes, inputStart, 256, 58)];
            if (bytes[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    @Override
    public byte[] decode(String input) throws ValidateException {
        int zeros;
        Validator.checkValid(() -> input != null && !input.isEmpty());
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            int digit;
            char c = input.charAt(i);
            int n = digit = c < '\u0080' ? INDEXES[c] : -1;
            if (digit < 0) {
                throw new ValidateException.InvalidCharacter(c, i);
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

