/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto.encoder;

import com.bitmark.sdk.crypto.encoder.Encoder;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;

public class Hex
implements Encoder {
    public static final Hex HEX = new Hex();
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    @Override
    public byte[] decode(String value) throws ValidateException {
        Validator.checkValidHex(value);
        char[] data = value.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    @Override
    public String encode(byte[] data) throws ValidateException {
        Validator.checkNonNull(data);
        Validator.checkValid(() -> data.length > 0);
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

