/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto.encoder;

import com.bitmark.sdk.crypto.encoder.Encoder;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Raw
implements Encoder {
    public static final Raw RAW = new Raw();
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    private Raw() {
    }

    @Override
    public byte[] decode(String data) throws ValidateException {
        Validator.checkValid(() -> data != null && !data.isEmpty());
        return data.getBytes(CHARSET);
    }

    @Override
    public String encode(byte[] data) throws ValidateException {
        Validator.checkValid(() -> data != null && data.length > 0);
        return new String(data, CHARSET);
    }
}

