/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto.key;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.key.Key;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Validator;

public class PrivateKey
implements Key {
    private final byte[] key;

    public static PrivateKey from(byte[] key) {
        return new PrivateKey(key);
    }

    public static PrivateKey from(String hexKey) throws ValidateException.InvalidHex {
        Validator.checkValidHex(hexKey);
        return new PrivateKey(hexKey);
    }

    protected PrivateKey(byte[] key) {
        this.key = key;
        Validator.checkValid(this::isValid);
    }

    protected PrivateKey(String hexKey) {
        this(Hex.HEX.decode(hexKey));
    }

    @Override
    public byte[] toBytes() {
        return this.key;
    }

    @Override
    public boolean isValid() {
        return this.key != null && this.key.length % 32 == 0;
    }

    @Override
    public int size() {
        return this.key.length;
    }

    public String toString() {
        return Hex.HEX.encode(this.key);
    }
}

