/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.crypto.key;

import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.crypto.key.PrivateKey;
import com.bitmark.sdk.crypto.key.PublicKey;
import com.bitmark.sdk.utils.Validator;

public class StandardKeyPair
implements KeyPair {
    private final byte[] publicKey;
    private final byte[] privateKey;

    public static StandardKeyPair from(byte[] publicKey, byte[] privateKey) {
        return new StandardKeyPair(publicKey, privateKey);
    }

    protected StandardKeyPair(byte[] publicKey, byte[] privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        Validator.checkValid(this::isValid);
    }

    @Override
    public PublicKey publicKey() {
        return PublicKey.from(this.publicKey);
    }

    @Override
    public PrivateKey privateKey() {
        return PrivateKey.from(this.privateKey);
    }

    @Override
    public boolean isValid() {
        return this.publicKey.length % 32 == 0 && this.privateKey.length % 32 == 0;
    }
}

