/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service;

import com.bitmark.sdk.service.AbsApiService;
import com.bitmark.sdk.service.BitmarkApi;
import com.bitmark.sdk.service.configuration.GlobalConfiguration;
import com.bitmark.sdk.service.middleware.Converter;
import com.bitmark.sdk.service.params.IssuanceParams;
import com.bitmark.sdk.service.params.RegistrationParams;
import com.bitmark.sdk.service.params.TransferOfferParams;
import com.bitmark.sdk.service.params.TransferParams;
import com.bitmark.sdk.service.params.TransferResponseParams;
import com.bitmark.sdk.service.params.query.QueryParams;
import com.bitmark.sdk.service.response.GetBitmarkResponse;
import com.bitmark.sdk.service.response.GetBitmarksResponse;
import com.bitmark.sdk.service.response.GetTransactionResponse;
import com.bitmark.sdk.service.response.GetTransactionsResponse;
import com.bitmark.sdk.service.response.RegistrationResponse;
import com.bitmark.sdk.utils.callback.Callback1;
import com.bitmark.sdk.utils.record.AssetRecord;
import java.util.List;
import okhttp3.Headers;

public class ApiService
extends AbsApiService
implements BitmarkApi {
    private static final String VERSION = "v3";
    private static volatile ApiService INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiService getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ApiService> clazz = ApiService.class;
        synchronized (ApiService.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ApiService(GlobalConfiguration.apiToken());
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ApiService(String apiToken) {
        super(apiToken);
    }

    @Override
    public void issueBitmark(IssuanceParams params, Callback1<List<String>> callback) {
        String path = String.format("/%s/issue", VERSION);
        this.postAsync(path, params, Converter.toIssueResponse(callback));
    }

    @Override
    public void registerAsset(RegistrationParams params, Callback1<RegistrationResponse> callback) {
        String path = String.format("/%s/register-asset", VERSION);
        this.postAsync(path, params, Converter.toRegistrationResponse(callback));
    }

    @Override
    public void transferBitmark(TransferParams params, Callback1<String> callback) {
        String path = String.format("/%s/transfer", VERSION);
        this.postAsync(path, params, Converter.toTxId(callback));
    }

    @Override
    public void offerBitmark(TransferOfferParams params, Callback1<String> callback) {
        String path = String.format("/%s/transfer", VERSION);
        this.postAsync(path, params, Converter.toOfferId(callback));
    }

    @Override
    public void respondBitmarkOffer(TransferResponseParams params, Callback1<String> callback) {
        String path = String.format("/%s/transfer", VERSION);
        Headers headers = Headers.of(params.buildHeaders());
        if (params.isAccept()) {
            this.patchAsync(path, headers, params, Converter.toTxId(callback));
        } else {
            this.patchAsync(path, headers, params, Converter.toStatus(callback));
        }
    }

    @Override
    public void getBitmark(String bitmarkId, boolean includeAsset, Callback1<GetBitmarkResponse> callback) {
        String path = String.format("/%s/bitmarks/%s?asset=%b", VERSION, bitmarkId, includeAsset);
        this.getAsync(path, Converter.toGetBitmarkResponse(callback));
    }

    @Override
    public void listBitmarks(QueryParams params, Callback1<GetBitmarksResponse> callback) {
        String path = String.format("/%s/bitmarks", VERSION);
        this.getAsync(path, params, Converter.toGetBitmarksResponse(callback));
    }

    @Override
    public void getAsset(String assetId, Callback1<AssetRecord> callback) {
        String path = String.format("/%s/assets/%s", VERSION, assetId);
        this.getAsync(path, Converter.toAssetRecord(callback));
    }

    @Override
    public void listAssets(QueryParams params, Callback1<List<AssetRecord>> callback) {
        String path = String.format("/%s/assets", VERSION);
        this.getAsync(path, params, Converter.toAssetRecords(callback));
    }

    @Override
    public void getTransaction(String txId, boolean includeAsset, Callback1<GetTransactionResponse> callback) {
        String path = String.format("/%s/txs/%s?asset=%b", VERSION, txId, includeAsset);
        this.getAsync(path, Converter.toGetTransactionResponse(callback));
    }

    @Override
    public void listTransactions(QueryParams params, Callback1<GetTransactionsResponse> callback) {
        String path = String.format("/%s/txs", VERSION);
        this.getAsync(path, params, Converter.toGetTransactionsResponse(callback));
    }
}

