/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service;

import com.bitmark.sdk.service.HttpClient;
import com.bitmark.sdk.service.configuration.GlobalConfiguration;
import com.bitmark.sdk.service.configuration.Network;
import com.bitmark.sdk.service.middleware.BitmarkApiInterceptor;
import com.bitmark.sdk.service.params.Params;
import com.bitmark.sdk.service.params.query.QueryParams;
import com.bitmark.sdk.utils.callback.Callback1;
import com.bitmark.sdk.utils.error.HttpException;
import com.bitmark.sdk.utils.error.NetworkException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpClientImpl
implements HttpClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String LIVE_NET_ENDPOINT = "https://api.bitmark.com";
    public static final String TEST_NET_ENDPOINT = "https://api.test.bitmark.com";
    private OkHttpClient client;

    HttpClientImpl(String apiToken) {
        this.client = this.buildClient(apiToken);
    }

    private OkHttpClient buildClient(String apiToken) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        builder.addInterceptor((Interceptor)new BitmarkApiInterceptor(apiToken));
        int timeout = GlobalConfiguration.connectionTimeout();
        builder.readTimeout((long)timeout, TimeUnit.SECONDS);
        builder.connectTimeout((long)timeout, TimeUnit.SECONDS);
        return builder.build();
    }

    private String getRequestUrl(String path) {
        return (GlobalConfiguration.network() == Network.TEST_NET ? TEST_NET_ENDPOINT : LIVE_NET_ENDPOINT) + path;
    }

    private String getRequestUrl(String path, QueryParams params) {
        return this.getRequestUrl(path) + "?" + params.toUrlQuery();
    }

    @Override
    public void getAsync(String path, Callback1<Response> callback) {
        this.getAsync(path, null, callback);
    }

    @Override
    public void getAsync(String path, QueryParams params, Callback1<Response> callback) {
        String requestUrl = params == null ? this.getRequestUrl(path) : this.getRequestUrl(path, params);
        Request request = new Request.Builder().url(requestUrl).get().build();
        this.client.newCall(request).enqueue(this.wrapCallback(callback));
    }

    @Override
    public void postAsync(String path, Params params, Callback1<Response> callback) {
        this.postAsync(path, null, params, callback);
    }

    @Override
    public void postAsync(String path, Headers headers, Params params, Callback1<Response> callback) {
        String requestUrl = this.getRequestUrl(path);
        Request.Builder builder = new Request.Builder().url(requestUrl).post(RequestBody.create((MediaType)JSON, (String)params.toJson()));
        if (headers != null) {
            builder.headers(headers);
        }
        this.client.newCall(builder.build()).enqueue(this.wrapCallback(callback));
    }

    @Override
    public void patchAsync(String path, Params params, Callback1<Response> callback) {
        this.patchAsync(path, null, params, callback);
    }

    @Override
    public void patchAsync(String path, Headers headers, Params params, Callback1<Response> callback) {
        String requestUrl = this.getRequestUrl(path);
        Request.Builder builder = new Request.Builder().url(requestUrl).patch(RequestBody.create((MediaType)JSON, (String)params.toJson()));
        if (headers != null) {
            builder.headers(headers);
        }
        this.client.newCall(builder.build()).enqueue(this.wrapCallback(callback));
    }

    @Override
    public void deleteAsync(String path, Callback1<Response> callback) {
        this.deleteAsync(path, null, callback);
    }

    @Override
    public void deleteAsync(String path, Params params, Callback1<Response> callback) {
        String requestUrl = this.getRequestUrl(path);
        Request.Builder builder = new Request.Builder().url(requestUrl);
        Request request = params == null ? builder.delete().build() : builder.delete(RequestBody.create((MediaType)JSON, (String)params.toJson())).build();
        this.client.newCall(request).enqueue(this.wrapCallback(callback));
    }

    private Callback wrapCallback(final Callback1<Response> callback) {
        return new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onError(new NetworkException(e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(response);
                } else {
                    callback.onError(new HttpException(response.code(), response.body().string()));
                }
            }
        };
    }
}

