/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.configuration;

import com.bitmark.sdk.service.configuration.Network;
import com.bitmark.sdk.utils.Validator;

public class GlobalConfiguration {
    private Builder builder;
    private static volatile GlobalConfiguration INSTANCE;

    public static Builder builder() {
        return new Builder();
    }

    public static void createInstance(String apiToken) {
        GlobalConfiguration.createInstance(new Builder(apiToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createInstance(Builder builder) {
        Validator.checkNonNull(builder);
        builder.validate();
        if (INSTANCE == null) {
            Class<GlobalConfiguration> clazz = GlobalConfiguration.class;
            synchronized (GlobalConfiguration.class) {
                if (INSTANCE == null) {
                    INSTANCE = new GlobalConfiguration(builder);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            throw new UnsupportedOperationException("GlobalConfiguration must be initialize once");
        }
    }

    public static boolean isInitialized() {
        return INSTANCE != null;
    }

    public static void destroy() {
        INSTANCE = null;
    }

    private GlobalConfiguration(Builder builder) {
        this.builder = builder;
    }

    public static Network network() {
        GlobalConfiguration.validate();
        return GlobalConfiguration.INSTANCE.builder.network;
    }

    public static String apiToken() {
        GlobalConfiguration.validate();
        return GlobalConfiguration.INSTANCE.builder.apiToken;
    }

    public static int connectionTimeout() {
        GlobalConfiguration.validate();
        return GlobalConfiguration.INSTANCE.builder.connectionTimeout;
    }

    private static void validate() {
        if (INSTANCE == null) {
            throw new UnsupportedOperationException("You must init Configuration before");
        }
    }

    public static final class Builder {
        private Network network = Network.TEST_NET;
        private String apiToken;
        private int connectionTimeout = 30;

        Builder() {
        }

        Builder(String apiToken) {
            this.apiToken = apiToken;
            this.validate();
        }

        public Builder withNetwork(Network network) {
            this.network = network;
            return this;
        }

        public Builder withApiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public void build() {
            GlobalConfiguration.createInstance(this);
        }

        private void validate() {
            if (this.apiToken == null || this.apiToken.isEmpty()) {
                throw new IllegalArgumentException("Api token is required");
            }
        }
    }
}

