/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.configuration;

public enum Network {
    LIVE_NET(0),
    TEST_NET(1);

    private int value;

    private Network(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static Network valueOf(int value) {
        switch (value) {
            case 0: {
                return LIVE_NET;
            }
            case 1: {
                return TEST_NET;
            }
        }
        throw new IllegalArgumentException("Invalid network");
    }

    public static boolean isValid(int value) {
        return value == Network.LIVE_NET.value || value == Network.TEST_NET.value;
    }
}

