/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.middleware;

import com.bitmark.sdk.service.response.GetBitmarkResponse;
import com.bitmark.sdk.service.response.GetBitmarksResponse;
import com.bitmark.sdk.service.response.GetTransactionResponse;
import com.bitmark.sdk.service.response.GetTransactionsResponse;
import com.bitmark.sdk.service.response.RegistrationResponse;
import com.bitmark.sdk.utils.callback.Callback1;
import com.bitmark.sdk.utils.error.UnexpectedException;
import com.bitmark.sdk.utils.record.AssetRecord;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Response;

public class Converter {
    private static final Gson GSON = new GsonBuilder().create();

    public static Callback1<Response> toIssueResponse(final Callback1<List<String>> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    Map mapJson = (Map)GSON.fromJson(raw, new TypeToken<Map<String, Object>>(){}.getType());
                    JsonArray jsonArray = GSON.toJsonTree(mapJson.get("bitmarks")).getAsJsonArray();
                    ArrayList txIds = new ArrayList(jsonArray.size());
                    jsonArray.forEach(jsonElement -> txIds.add(jsonElement.getAsJsonObject().get("id").getAsString()));
                    callback.onSuccess(txIds);
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toRegistrationResponse(final Callback1<RegistrationResponse> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    RegistrationResponse response = (RegistrationResponse)GSON.fromJson(raw, RegistrationResponse.class);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toTxId(final Callback1<String> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response response) {
                try {
                    String raw = response.body().string();
                    Map json = (Map)GSON.fromJson(raw, new TypeToken<Map<String, String>>(){}.getType());
                    callback.onSuccess(json.get("txid"));
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toStatus(final Callback1<String> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response response) {
                try {
                    String raw = response.body().string();
                    Map json = (Map)GSON.fromJson(raw, new TypeToken<Map<String, String>>(){}.getType());
                    callback.onSuccess(json.get("status"));
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toOfferId(final Callback1<String> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response response) {
                try {
                    String raw = response.body().string();
                    Map json = (Map)GSON.fromJson(raw, new TypeToken<Map<String, String>>(){}.getType());
                    callback.onSuccess(json.get("offer_id"));
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toGetBitmarkResponse(final Callback1<GetBitmarkResponse> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    callback.onSuccess(GSON.fromJson(raw, GetBitmarkResponse.class));
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toGetBitmarksResponse(final Callback1<GetBitmarksResponse> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    callback.onSuccess(GSON.fromJson(raw, GetBitmarksResponse.class));
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toAssetRecord(final Callback1<AssetRecord> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    Map jsonMap = (Map)GSON.fromJson(raw, new TypeToken<Map<String, Object>>(){}.getType());
                    String json = GSON.toJsonTree(jsonMap.get("asset")).getAsJsonObject().toString();
                    AssetRecord asset = (AssetRecord)GSON.fromJson(json, AssetRecord.class);
                    callback.onSuccess(asset);
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toAssetRecords(final Callback1<List<AssetRecord>> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    Map jsonMap = (Map)GSON.fromJson(raw, new TypeToken<Map<String, Object>>(){}.getType());
                    String json = GSON.toJsonTree(jsonMap.get("assets")).getAsJsonArray().toString();
                    List assets = (List)GSON.fromJson(json, new TypeToken<List<AssetRecord>>(){}.getType());
                    callback.onSuccess(assets);
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toGetTransactionResponse(final Callback1<GetTransactionResponse> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    GetTransactionResponse response = (GetTransactionResponse)GSON.fromJson(raw, GetTransactionResponse.class);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }

    public static Callback1<Response> toGetTransactionsResponse(final Callback1<GetTransactionsResponse> callback) {
        return new Callback1<Response>(){

            @Override
            public void onSuccess(Response res) {
                try {
                    String raw = res.body().string();
                    GetTransactionsResponse response = (GetTransactionsResponse)GSON.fromJson(raw, GetTransactionsResponse.class);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    callback.onError(new UnexpectedException(e));
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        };
    }
}

