/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.Ed25519;
import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.service.params.MultipleParams;
import com.bitmark.sdk.utils.Validator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsMultipleParams
implements MultipleParams {
    protected List<byte[]> signatures;

    @Override
    public List<byte[]> sign(KeyPair key) {
        Validator.checkValid(() -> key != null && key.isValid(), "Invalid key pair");
        this.signatures = new ArrayList<byte[]>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.signatures.add(Ed25519.sign(this.pack(i), key.privateKey().toBytes()));
        }
        return this.signatures;
    }

    abstract byte[] pack(int var1);

    abstract int size();

    public List<byte[]> getSignatures() {
        return this.signatures;
    }

    @Override
    public boolean isSigned() {
        return this.signatures != null && !this.signatures.isEmpty();
    }

    protected void checkSigned() {
        if (!this.isSigned()) {
            throw new UnsupportedOperationException("Params need to be signed before");
        }
    }
}

