/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.Ed25519;
import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.service.params.SingleParams;
import com.bitmark.sdk.utils.Validator;

public abstract class AbsSingleParams
implements SingleParams {
    protected byte[] signature;

    @Override
    public byte[] sign(KeyPair key) {
        Validator.checkValid(() -> key != null && key.isValid(), "Invalid key pair");
        this.signature = Ed25519.sign(this.pack(), key.privateKey().toBytes());
        return this.signature;
    }

    abstract byte[] pack();

    public String getSignature() {
        return Hex.HEX.encode(this.signature);
    }

    @Override
    public boolean isSigned() {
        return this.signature != null;
    }

    protected void checkSigned() {
        if (!this.isSigned()) {
            throw new UnsupportedOperationException("Params need to be signed before");
        }
    }
}

