/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.Random;
import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.service.params.AbsMultipleParams;
import com.bitmark.sdk.utils.Address;
import com.bitmark.sdk.utils.ArrayUtil;
import com.bitmark.sdk.utils.BinaryPacking;
import com.bitmark.sdk.utils.Validator;

public class IssuanceParams
extends AbsMultipleParams {
    private static final int ASSET_ID_LENGTH = 64;
    private String assetId;
    private int[] nonces;
    private Address owner;

    public IssuanceParams(String assetId, Address owner) throws ValidateException {
        Validator.checkValidHex(assetId);
        Validator.checkValid(() -> Hex.HEX.decode(assetId).length <= 64);
        Validator.checkValid(() -> owner != null && owner.isValid(), "Invalid Address");
        this.assetId = assetId;
        this.owner = owner;
        this.nonces = new int[]{Random.secureRandomInt()};
    }

    public IssuanceParams(String assetId, Address owner, int[] nonces) throws ValidateException {
        this(assetId, owner);
        Validator.checkValid(() -> nonces != null && nonces.length > 0 && !ArrayUtil.isDuplicate(nonces) && ArrayUtil.isPositive(nonces));
        this.nonces = nonces;
    }

    public IssuanceParams(String assetId, Address owner, int quantity) throws ValidateException {
        this(assetId, owner);
        Validator.checkValid(() -> quantity > 0);
        int[] examinedNonce = Random.secureRandomInts(quantity);
        Validator.checkValid(() -> !ArrayUtil.isDuplicate(examinedNonce) && ArrayUtil.isPositive(examinedNonce));
        this.nonces = examinedNonce;
    }

    public int[] getNonces() {
        return this.nonces;
    }

    @Override
    public String toJson() {
        this.checkSigned();
        StringBuilder builder = new StringBuilder();
        builder.append("{\"issues\":[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            builder.append(this.buildSingleJson(i));
            if (i >= size - 1) continue;
            builder.append(",");
        }
        builder.append("]}");
        return builder.toString();
    }

    @Override
    byte[] pack(int index) {
        byte[] assetId = Hex.HEX.decode(this.assetId);
        byte[] data = VarInt.writeUnsignedVarInt(3);
        data = BinaryPacking.concat(assetId, data);
        data = BinaryPacking.concat(this.owner.pack(), data);
        data = ArrayUtil.concat(data, VarInt.writeUnsignedVarInt(this.nonces[index]));
        return data;
    }

    @Override
    int size() {
        return this.nonces.length;
    }

    private String buildSingleJson(int index) {
        return "{\"owner\":\"" + this.owner.getAddress() + "\",\"signature\":\"" + Hex.HEX.encode((byte[])this.signatures.get(index)) + "\",\"asset_id\":\"" + this.assetId + "\",\"nonce\":" + this.nonces[index] + "}";
    }
}

