/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.Sha3512;
import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.service.params.AbsSingleParams;
import com.bitmark.sdk.utils.Address;
import com.bitmark.sdk.utils.BinaryPacking;
import com.bitmark.sdk.utils.FileUtils;
import com.bitmark.sdk.utils.Validator;
import com.bitmark.sdk.utils.error.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class RegistrationParams
extends AbsSingleParams {
    private String name;
    private Map<String, String> metadata;
    private String fingerprint;
    private Address registrant;

    public RegistrationParams(String name, Map<String, String> metadata, Address registrant) throws ValidateException {
        Validator.checkValid(() -> name != null && metadata != null && registrant != null && !name.isEmpty() && metadata.size() > 0 && registrant.isValid(), "Invalid RegistrationParams");
        this.name = name;
        this.metadata = metadata;
        this.registrant = registrant;
    }

    public String generateFingerprint(File file) {
        Validator.checkValid(() -> file != null, "Invalid file. File is null");
        CompletableFuture<String> task = CompletableFuture.supplyAsync(() -> {
            try {
                this.fingerprint = this.computeFingerprint(file);
                return this.fingerprint;
            }
            catch (IOException e) {
                throw new CompletionException(new UnexpectedException("Error when trying compute fingerprint from file " + file.getAbsolutePath()));
            }
        });
        return task.join();
    }

    @Override
    public String toJson() {
        this.checkSigned();
        return "{\"assets\":[{\"fingerprint\":\"" + this.fingerprint + "\",\"name\":\"" + this.name + "\",\"metadata\":\"" + this.getJsonMetadata(this.metadata) + "\",\"registrant\":\"" + this.registrant.getAddress() + "\",\"signature\":\"" + Hex.HEX.encode(this.signature) + "\"}]}";
    }

    @Override
    byte[] pack() {
        byte[] data = VarInt.writeUnsignedVarInt(2);
        data = BinaryPacking.concat(this.name, data);
        data = BinaryPacking.concat(this.fingerprint, data);
        data = BinaryPacking.concat(this.getPackedMetadata(this.metadata), data);
        data = BinaryPacking.concat(this.registrant.pack(), data);
        return data;
    }

    private String computeFingerprint(File file) throws IOException {
        byte[] bytes = FileUtils.getBytes(file);
        byte[] hashedBytes = Sha3512.hash(bytes);
        return "01" + Hex.HEX.encode(hashedBytes);
    }

    private String getPackedMetadata(Map<String, String> metadata) {
        StringBuilder builder = new StringBuilder();
        int iteration = 0;
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            builder.append(entry.getKey()).append('\u0000').append(entry.getValue());
            if (++iteration >= metadata.size()) continue;
            builder.append('\u0000');
        }
        return builder.toString();
    }

    private String getJsonMetadata(Map<String, String> metadata) {
        StringBuilder builder = new StringBuilder();
        int iteration = 0;
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            builder.append(entry.getKey()).append("\\u0000").append(entry.getValue());
            if (++iteration >= metadata.size()) continue;
            builder.append("\\u0000");
        }
        return builder.toString();
    }
}

