/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.service.params.AbsSingleParams;
import com.bitmark.sdk.utils.Address;
import com.bitmark.sdk.utils.ArrayUtil;
import com.bitmark.sdk.utils.BinaryPacking;
import com.bitmark.sdk.utils.Validator;
import java.util.Map;

public class TransferOfferParams
extends AbsSingleParams {
    private Address offeredOwner;
    private String link;
    private Map<String, String> extraInfo;

    public TransferOfferParams(Address offeredOwner) {
        Validator.checkValid(() -> offeredOwner != null && offeredOwner.isValid(), "Invalid offer owner address");
        this.offeredOwner = offeredOwner;
    }

    public TransferOfferParams(Address offeredOwner, String link) {
        this(offeredOwner);
        this.setLink(link);
    }

    public void setExtraInfo(Map<String, String> extraInfo) {
        this.extraInfo = extraInfo;
    }

    public void setLink(String link) {
        this.checkValidLink(link);
        this.link = link;
    }

    @Override
    public String toJson() {
        this.checkSigned();
        return "{\"offer\":{\"extra_info\":{" + this.getExtraInfoJson() + "},\"record\":{\"link\":\"" + this.link + "\",\"owner\":\"" + this.offeredOwner.getAddress() + "\",\"signature\":\"" + Hex.HEX.encode(this.signature) + "\"}}}";
    }

    @Override
    public byte[] sign(KeyPair key) {
        this.checkValidLink(this.link);
        return super.sign(key);
    }

    @Override
    byte[] pack() {
        byte[] data = VarInt.writeUnsignedVarInt(5);
        data = BinaryPacking.concat(Hex.HEX.decode(this.link), data);
        data = ArrayUtil.concat(data, new byte[]{0});
        data = BinaryPacking.concat(this.offeredOwner.pack(), data);
        return data;
    }

    private void checkValidLink(String link) {
        Validator.checkValid(() -> link != null && Hex.HEX.decode(link).length == 32, "Invalid link");
    }

    private String getExtraInfoJson() {
        return "";
    }
}

