/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.service.params.AbsSingleParams;
import com.bitmark.sdk.utils.Address;
import com.bitmark.sdk.utils.ArrayUtil;
import com.bitmark.sdk.utils.BinaryPacking;
import com.bitmark.sdk.utils.Validator;

public class TransferParams
extends AbsSingleParams {
    private Address owner;
    private String link;

    public TransferParams(Address owner) {
        Validator.checkValid(() -> owner != null && owner.isValid(), "Invalid owner address");
        this.owner = owner;
    }

    public TransferParams(Address owner, String link) {
        this(owner);
        this.setLink(link);
    }

    public void setLink(String link) {
        this.checkValidLink(link);
        this.link = link;
    }

    @Override
    public String toJson() {
        this.checkSigned();
        return "{\"transfer\":{\"link\":\"" + this.link + "\",\"owner\":\"" + this.owner.getAddress() + "\",\"signature\":\"" + Hex.HEX.encode(this.signature) + "\"}}";
    }

    @Override
    public byte[] sign(KeyPair key) {
        this.checkValidLink(this.link);
        return super.sign(key);
    }

    @Override
    byte[] pack() {
        byte[] data = VarInt.writeUnsignedVarInt(4);
        data = BinaryPacking.concat(Hex.HEX.decode(this.link), data);
        data = ArrayUtil.concat(data, new byte[]{0});
        data = BinaryPacking.concat(this.owner.pack(), data);
        return data;
    }

    private void checkValidLink(String link) {
        Validator.checkValid(() -> link != null && Hex.HEX.decode(link).length == 32, "Invalid link");
    }
}

