/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params;

import com.bitmark.sdk.crypto.Ed25519;
import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.encoder.Raw;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.crypto.key.KeyPair;
import com.bitmark.sdk.service.params.AbsSingleParams;
import com.bitmark.sdk.utils.Address;
import com.bitmark.sdk.utils.ArrayUtil;
import com.bitmark.sdk.utils.BinaryPacking;
import com.bitmark.sdk.utils.Validator;
import com.bitmark.sdk.utils.record.OfferRecord;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class TransferResponseParams
extends AbsSingleParams {
    private OfferRecord offer;
    private Response response;
    private KeyPair key;
    private String currentOwner;

    public static TransferResponseParams accept(OfferRecord offer) {
        return new TransferResponseParams(offer, Response.ACCEPT);
    }

    public static TransferResponseParams reject(OfferRecord offer) {
        return new TransferResponseParams(offer, Response.REJECT);
    }

    public static TransferResponseParams cancel(OfferRecord offer, String owner) {
        TransferResponseParams params = new TransferResponseParams(offer, Response.CANCEL);
        params.setCurrentOwner(owner);
        return params;
    }

    private TransferResponseParams(OfferRecord offer, Response response) {
        Validator.checkNonNull(offer);
        Validator.checkNonNull(response);
        this.offer = offer;
        this.response = response;
    }

    @Override
    byte[] pack() {
        byte[] data = VarInt.writeUnsignedVarInt(5);
        data = BinaryPacking.concat(Hex.HEX.decode(this.offer.getLink()), data);
        data = ArrayUtil.concat(data, new byte[]{0});
        data = BinaryPacking.concat(Address.fromAccountNumber(this.offer.getOwner()).pack(), data);
        data = BinaryPacking.concat(Hex.HEX.decode(this.offer.getSignature()), data);
        return data;
    }

    @Override
    public byte[] sign(KeyPair key) {
        Validator.checkValid(this::isAccept, "Only accept response params need to be signed");
        this.setSigningKey(key);
        return super.sign(key);
    }

    public void setSigningKey(KeyPair key) {
        this.key = key;
    }

    @Override
    public String toJson() {
        if (this.isAccept()) {
            this.checkSigned();
        }
        return "{\"action\":\"" + this.response.value + (this.isAccept() ? "\",\"countersignature\":\"" + Hex.HEX.encode(this.signature) : "") + "\",\"id\":\"" + this.offer.getId() + "\"}";
    }

    public Map<String, String> buildHeaders() {
        return this.buildHeaders(Calendar.getInstance().getTimeInMillis());
    }

    public Map<String, String> buildHeaders(long time) {
        Validator.checkValid(() -> this.key != null && this.key.isValid(), "Invalid or missing key for signing");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requester = this.isCancel() ? this.currentOwner : this.offer.getOwner();
        String message = String.format("updateOffer|%s|%s|%s", this.offer.getId(), requester, String.valueOf(time));
        byte[] signature = Ed25519.sign(Raw.RAW.decode(message), this.key.privateKey().toBytes());
        headers.put("requester", requester);
        headers.put("timestamp", String.valueOf(time));
        headers.put("signature", Hex.HEX.encode(signature));
        return headers;
    }

    private void setCurrentOwner(String owner) {
        Validator.checkValidString(owner);
        this.currentOwner = owner;
    }

    public boolean isAccept() {
        return this.response == Response.ACCEPT;
    }

    private boolean isCancel() {
        return this.response == Response.CANCEL;
    }

    static enum Response {
        ACCEPT("accept"),
        REJECT("reject"),
        CANCEL("cancel");

        private String value;

        private Response(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

