/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params.query;

import com.bitmark.sdk.service.params.query.QueryBuilder;
import com.bitmark.sdk.service.params.query.QueryParams;
import com.bitmark.sdk.service.params.query.QueryParamsImpl;
import com.bitmark.sdk.utils.HttpUtils;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public abstract class AbsQueryBuilder
implements QueryBuilder {
    @Override
    public QueryParams build() {
        return new QueryParamsImpl(this);
    }

    @Override
    public String toUrlQuery() {
        try {
            StringBuilder builder = new StringBuilder();
            Map<String, Object> valueMap = this.getValues(this);
            int iteration = 0;
            for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                ++iteration;
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value.getClass().isArray()) {
                    builder.append(HttpUtils.buildArrayQueryString(name, value));
                } else {
                    builder.append(name).append("=").append(value.toString());
                }
                if (iteration >= valueMap.size()) continue;
                builder.append("&");
            }
            return builder.toString();
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Map<String, Object> getValues(QueryBuilder builder) throws IllegalAccessException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Field[] fields = builder.getClass().getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(builder);
                if (value == null) continue;
                SerializedName annotationName = field.getAnnotation(SerializedName.class);
                String name = annotationName != null ? annotationName.value() : field.getName();
                valueMap.put(name, value);
            }
        }
        return valueMap;
    }
}

