/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params.query;

import com.bitmark.sdk.service.params.query.AbsQueryBuilder;
import com.bitmark.sdk.utils.Validator;
import com.google.gson.annotations.SerializedName;

public class BitmarkQueryBuilder
extends AbsQueryBuilder {
    private String owner;
    @SerializedName(value="issued_by")
    private String issuedBy;
    @SerializedName(value="pending")
    private boolean isPending;
    @SerializedName(value="offer_to")
    private String offerTo;
    @SerializedName(value="offer_from")
    private String offerFrom;
    @SerializedName(value="bitmark_ids")
    private String[] bitmarkIds;
    @SerializedName(value="asset_id")
    private String referencedAssetId;
    @SerializedName(value="asset")
    private boolean loadAsset;
    private int limit = 100;

    public BitmarkQueryBuilder ownedBy(String owner) {
        Validator.checkValidString(owner);
        this.owner = owner;
        return this;
    }

    public BitmarkQueryBuilder issuedBy(String issuedBy) {
        Validator.checkValidString(issuedBy);
        this.issuedBy = issuedBy;
        return this;
    }

    public BitmarkQueryBuilder pending(boolean pending) {
        this.isPending = pending;
        return this;
    }

    public BitmarkQueryBuilder offerTo(String offerTo) {
        Validator.checkValidString(offerTo);
        this.offerTo = offerTo;
        return this;
    }

    public BitmarkQueryBuilder offerFrom(String offerFrom) {
        Validator.checkValidString(offerFrom);
        this.offerFrom = offerFrom;
        return this;
    }

    public BitmarkQueryBuilder bitmarkIds(String[] bitmarkIds) {
        Validator.checkValid(() -> bitmarkIds != null && bitmarkIds.length > 0, "Invalid bitmark id list");
        this.bitmarkIds = bitmarkIds;
        return this;
    }

    public BitmarkQueryBuilder referencedAssetId(String referencedAssetId) {
        Validator.checkValidString(referencedAssetId);
        this.referencedAssetId = referencedAssetId;
        return this;
    }

    public BitmarkQueryBuilder loadAsset(boolean loadAsset) {
        this.loadAsset = loadAsset;
        return this;
    }

    public BitmarkQueryBuilder limit(int limit) {
        Validator.checkValid(() -> limit > 0, "Invalid limit value. Must be greater 0");
        this.limit = limit;
        return this;
    }
}

