/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.service.params.query;

import com.bitmark.sdk.service.params.query.AbsQueryBuilder;
import com.bitmark.sdk.utils.Validator;
import com.google.gson.annotations.SerializedName;

public class TransactionQueryBuilder
extends AbsQueryBuilder {
    private String owner;
    @SerializedName(value="asset_id")
    private String assetId;
    @SerializedName(value="bitmark_id")
    private String bitmarkId;
    @SerializedName(value="asset")
    private boolean loadAsset;
    private int limit = 100;

    public TransactionQueryBuilder ownedBy(String owner) {
        Validator.checkValidString(owner);
        this.owner = owner;
        return this;
    }

    public TransactionQueryBuilder referenceAsset(String assetId) {
        Validator.checkValidString(assetId);
        this.assetId = assetId;
        return this;
    }

    public TransactionQueryBuilder referenceBitmark(String bitmarkId) {
        Validator.checkValidString(bitmarkId);
        this.bitmarkId = bitmarkId;
        return this;
    }

    public TransactionQueryBuilder loadAsset(boolean loadAsset) {
        this.loadAsset = loadAsset;
        return this;
    }

    public TransactionQueryBuilder limit(int limit) {
        Validator.checkValid(() -> limit > 0, "Invalid limit value");
        this.limit = limit;
        return this;
    }
}

