/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.sdk.crypto.Sha3256;
import com.bitmark.sdk.crypto.encoder.Base58;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.crypto.key.PublicKey;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.service.configuration.GlobalConfiguration;
import com.bitmark.sdk.service.configuration.KeyPart;
import com.bitmark.sdk.service.configuration.Network;
import com.bitmark.sdk.utils.ArrayUtil;
import com.bitmark.sdk.utils.Validation;
import com.bitmark.sdk.utils.Validator;
import com.bitmark.sdk.utils.error.InvalidAddressException;
import com.bitmark.sdk.utils.error.InvalidNetworkException;
import java.util.Arrays;

public class Address
implements Validation {
    public static final int CHECKSUM_LENGTH = 4;
    private PublicKey key;
    private Network network;

    public static Address fromAccountNumber(String accountNumber) {
        byte[] addressBytes = Base58.BASE_58.decode(accountNumber);
        int keyVariant = VarInt.readUnsignedVarInt(addressBytes);
        int keyVariantLength = ArrayUtil.toByteArray(keyVariant).length;
        int addressLength = keyVariantLength + 32 + 4;
        if (addressLength != addressBytes.length) {
            throw new InvalidAddressException("Address length is invalid. The expected is " + addressLength + " but actual is " + addressBytes.length);
        }
        byte[] checksumData = ArrayUtil.slice(addressBytes, 0, keyVariantLength + 32);
        byte[] checksum = ArrayUtil.slice(Sha3256.hash(checksumData), 0, 4);
        byte[] checksumFromAddress = ArrayUtil.slice(addressBytes, addressLength - 4, addressLength);
        if (!ArrayUtil.equals(checksumFromAddress, checksum)) {
            throw new InvalidAddressException("Invalid checksum. The expected is " + Arrays.toString(checksum) + " but actual is " + Arrays.toString(checksumFromAddress));
        }
        if ((keyVariant & 1) != KeyPart.PUBLIC_KEY.value()) {
            throw new InvalidAddressException();
        }
        int networkValue = keyVariant >> 1 & 1;
        Network network = Network.valueOf(networkValue);
        if (!Network.isValid(networkValue) || GlobalConfiguration.network() != network) {
            throw new InvalidNetworkException(networkValue);
        }
        byte[] publicKey = ArrayUtil.slice(addressBytes, keyVariantLength, addressLength - 4);
        return new Address(PublicKey.from(publicKey), network);
    }

    public static Address getDefault(PublicKey key, Network network) throws ValidateException {
        Validator.checkNonNull(key);
        Validator.checkNonNull(network);
        return new Address(key, network);
    }

    private Address() {
    }

    private Address(PublicKey key, Network network) {
        this();
        this.key = key;
        this.network = network;
    }

    public byte[] pack() {
        return ArrayUtil.concat(this.getPrefix(), this.key.toBytes());
    }

    @Override
    public boolean isValid() {
        return this.key != null && this.key.size() == 32 && this.network != null;
    }

    public Network getNetwork() {
        return this.network;
    }

    public PublicKey getKey() {
        return this.key;
    }

    public String getAddress() {
        byte[] keyVariantVarInt = this.getPrefix();
        byte[] publicKeyBytes = this.key.toBytes();
        byte[] preChecksum = ArrayUtil.concat(keyVariantVarInt, publicKeyBytes);
        byte[] checksum = ArrayUtil.slice(Sha3256.hash(preChecksum), 0, 4);
        byte[] address = ArrayUtil.concat(keyVariantVarInt, publicKeyBytes, checksum);
        return Base58.BASE_58.encode(address);
    }

    public byte[] getPrefix() {
        int keyVariantValue = 16;
        keyVariantValue |= KeyPart.PUBLIC_KEY.value();
        return VarInt.writeUnsignedVarInt(keyVariantValue |= this.network.value() << 1);
    }
}

