/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static int toPrimitiveInteger(byte[] value) {
        return new BigInteger(value).intValue();
    }

    public static byte[] toByteArray(int value) throws BufferUnderflowException {
        byte[] byArray;
        if (value == 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byArray = ArrayUtil.minimize(ByteBuffer.allocate(4).putInt(value).array());
        }
        return byArray;
    }

    public static byte[] toByteArray(int[] value) {
        int length = value.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)value[i];
        }
        return result;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        if (a != null && b != null) {
            boolean[] rv = new boolean[a.length + b.length];
            System.arraycopy(a, 0, rv, 0, a.length);
            System.arraycopy(b, 0, rv, a.length, b.length);
            return rv;
        }
        if (b != null) {
            return ArrayUtil.clone(b);
        }
        return ArrayUtil.clone(a);
    }

    public static int[] concat(int[] a, int[] b) {
        if (a != null && b != null) {
            int[] rv = new int[a.length + b.length];
            System.arraycopy(a, 0, rv, 0, a.length);
            System.arraycopy(b, 0, rv, a.length, b.length);
            return rv;
        }
        if (b != null) {
            return ArrayUtil.clone(b);
        }
        return ArrayUtil.clone(a);
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (a != null && b != null) {
            byte[] rv = new byte[a.length + b.length];
            System.arraycopy(a, 0, rv, 0, a.length);
            System.arraycopy(b, 0, rv, a.length, b.length);
            return rv;
        }
        if (b != null) {
            return ArrayUtil.clone(b);
        }
        return ArrayUtil.clone(a);
    }

    public static byte[] concat(byte[] a, byte[] b, byte[] c) {
        if (a != null && b != null && c != null) {
            byte[] rv = new byte[a.length + b.length + c.length];
            System.arraycopy(a, 0, rv, 0, a.length);
            System.arraycopy(b, 0, rv, a.length, b.length);
            System.arraycopy(c, 0, rv, a.length + b.length, c.length);
            return rv;
        }
        if (a == null) {
            return ArrayUtil.concat(b, c);
        }
        if (b == null) {
            return ArrayUtil.concat(a, c);
        }
        return ArrayUtil.concat(a, b);
    }

    public static byte[] concat(byte[] a, byte[] b, byte[] c, byte[] d) {
        if (a != null && b != null && c != null && d != null) {
            byte[] rv = new byte[a.length + b.length + c.length + d.length];
            System.arraycopy(a, 0, rv, 0, a.length);
            System.arraycopy(b, 0, rv, a.length, b.length);
            System.arraycopy(c, 0, rv, a.length + b.length, c.length);
            System.arraycopy(d, 0, rv, a.length + b.length + c.length, d.length);
            return rv;
        }
        if (d == null) {
            return ArrayUtil.concat(a, b, c);
        }
        if (c == null) {
            return ArrayUtil.concat(a, b, d);
        }
        if (b == null) {
            return ArrayUtil.concat(a, c, d);
        }
        return ArrayUtil.concat(b, c, d);
    }

    public static boolean equals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static int[] clone(int[] data) {
        if (data == null) {
            return null;
        }
        int[] copy = new int[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public static byte[] clone(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public static boolean[] clone(boolean[] data) {
        if (data == null) {
            return null;
        }
        boolean[] copy = new boolean[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public static byte[] slice(byte[] data, int from, int to) {
        return Arrays.copyOfRange(data, from, to);
    }

    public static boolean[] slice(boolean[] data, int from, int to) {
        return Arrays.copyOfRange(data, from, to);
    }

    public static byte[] minimize(byte[] data) {
        int i = 0;
        for (byte b : data) {
            if (b != 0) break;
            ++i;
        }
        return ArrayUtil.slice(data, i, data.length);
    }

    public static boolean contains(String[] source, String examined) {
        for (String item : source) {
            if (!item.equals(examined)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String[] source, String[] examined) {
        for (String item : examined) {
            if (ArrayUtil.contains(source, item)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String[] source, String examined) {
        for (int i = 0; i < source.length; ++i) {
            if (!source[i].equals(examined)) continue;
            return i;
        }
        return -1;
    }

    public static int[] toUInt(byte[] data) {
        int length = data.length;
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = data[i] & 0xFF;
        }
        return result;
    }

    public static boolean isDuplicate(String[] input) {
        ArrayList<String> nonDupArray = new ArrayList<String>();
        for (String item : input) {
            if (nonDupArray.contains(item)) {
                return true;
            }
            nonDupArray.add(item);
        }
        return false;
    }

    public static boolean isDuplicate(int[] input) {
        ArrayList<Integer> nonDupArray = new ArrayList<Integer>();
        for (int item : input) {
            if (nonDupArray.contains(item)) {
                return true;
            }
            nonDupArray.add(item);
        }
        return false;
    }

    public static boolean isPositive(int[] input) {
        for (int item : input) {
            if (item >= 0) continue;
            return false;
        }
        return true;
    }

    public static Integer[] toIntegerArray(int[] input) {
        return (Integer[])Arrays.stream(input).boxed().toArray(Integer[]::new);
    }

    public static Long[] toLongArray(long[] input) {
        return (Long[])Arrays.stream(input).boxed().toArray(Long[]::new);
    }

    public static Double[] toDoubleArray(double[] input) {
        return (Double[])Arrays.stream(input).boxed().toArray(Double[]::new);
    }

    public static Float[] toFloatArray(float[] input) {
        return (Float[])IntStream.range(0, input.length).mapToDouble(i -> input[i]).boxed().toArray(Float[]::new);
    }
}

