/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BackgroundJobScheduler {
    private static final int MAX_POOL_SIZE = 10;
    private static final int ALIVE_TIME = 60;
    private static final TimeUnit ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final ThreadFactory THREAD_FACTORY = new PriorityThreadFactory(5);
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 10, 60L, ALIVE_TIME_UNIT, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);

    public void execute(Runnable runnable) {
        executor.execute(runnable);
    }

    public void shutdown() {
        if (executor.isShutdown() || executor.isTerminating() || executor.isTerminated()) {
            return;
        }
        executor.shutdown();
    }

    static final class PriorityThreadFactory
    implements ThreadFactory {
        private final int priority;

        PriorityThreadFactory(int priority) {
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setPriority(this.priority);
            return thread;
        }
    }
}

