/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.sdk.utils.ArrayUtil;

public class HttpUtils {
    private HttpUtils() {
    }

    public static String buildArrayQueryString(String name, Object value) {
        if (!value.getClass().isArray()) {
            return name + "=" + String.valueOf(value);
        }
        if (value instanceof String[]) {
            return HttpUtils.buildArrayQueryString(name, (String[])value);
        }
        if (value instanceof Integer[]) {
            return HttpUtils.buildArrayQueryString(name, (Integer[])value);
        }
        if (value instanceof Long[]) {
            return HttpUtils.buildArrayQueryString(name, (Long[])value);
        }
        if (value instanceof Float[]) {
            return HttpUtils.buildArrayQueryString(name, (Float[])value);
        }
        if (value instanceof Double[]) {
            return HttpUtils.buildArrayQueryString(name, (Double[])value);
        }
        if (value instanceof int[]) {
            return HttpUtils.buildArrayQueryString(name, ArrayUtil.toIntegerArray((int[])value));
        }
        if (value instanceof long[]) {
            return HttpUtils.buildArrayQueryString(name, ArrayUtil.toLongArray((long[])value));
        }
        if (value instanceof double[]) {
            return HttpUtils.buildArrayQueryString(name, ArrayUtil.toDoubleArray((double[])value));
        }
        if (value instanceof float[]) {
            return HttpUtils.buildArrayQueryString(name, ArrayUtil.toFloatArray((float[])value));
        }
        throw new UnsupportedOperationException("Unsupported object value");
    }

    public static <T> String buildArrayQueryString(String name, T[] values) {
        StringBuilder builder = new StringBuilder();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            builder.append(name).append("=").append(String.valueOf(values[i]));
            if (i >= length - 1) continue;
            builder.append("&");
        }
        return builder.toString();
    }
}

