/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.sdk.crypto.Sha3256;
import com.bitmark.sdk.crypto.encoder.Base58;
import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.crypto.encoder.VarInt;
import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.service.configuration.GlobalConfiguration;
import com.bitmark.sdk.service.configuration.Network;
import com.bitmark.sdk.utils.ArrayUtil;
import com.bitmark.sdk.utils.SequenceIterateByteArray;
import com.bitmark.sdk.utils.Validator;
import com.bitmark.sdk.utils.error.InvalidChecksumException;
import com.bitmark.sdk.utils.error.InvalidNetworkException;
import com.bitmark.sdk.utils.error.InvalidSeedException;
import java.util.Arrays;

public class Seed {
    public static final int LENGTH = 32;
    public static final int VERSION = 1;
    private static final int ENCODED_LENGTH = 40;
    private static final byte[] MAGIC_NUMBER = Hex.HEX.decode("5AFE");
    private static final int NETWORK_LENGTH = 1;
    private static final int CHECKSUM_LENGTH = 4;
    private byte[] seed;
    private Network network;
    private int version;

    public static Seed fromEncodedSeed(String encodedSeed) throws ValidateException {
        byte[] seedBytes = Base58.BASE_58.decode(encodedSeed);
        Validator.checkValidLength(seedBytes, 40);
        int length = seedBytes.length;
        byte[] checksum = ArrayUtil.slice(seedBytes, length - 4, length);
        SequenceIterateByteArray data = new SequenceIterateByteArray(Arrays.copyOfRange(seedBytes, 0, length - 4));
        byte[] dataHashed = Sha3256.hash(data.getBytes());
        byte[] checksumVerification = ArrayUtil.slice(dataHashed, 0, 4);
        Validator.checkValid(() -> Arrays.equals(checksum, checksumVerification), new InvalidChecksumException(checksumVerification, checksum));
        byte[] magicNumber = data.next(MAGIC_NUMBER.length);
        Validator.checkValid(() -> Arrays.equals(magicNumber, MAGIC_NUMBER), new InvalidSeedException.InvalidMagicNumberException(magicNumber, MAGIC_NUMBER));
        byte[] encodedSeedVersion = VarInt.writeUnsignedVarInt(1);
        byte[] version = data.next(encodedSeedVersion.length);
        Validator.checkValid(() -> Arrays.equals(version, encodedSeedVersion), new InvalidSeedException.InvalidVersionException(version, encodedSeedVersion));
        int network = ArrayUtil.toPrimitiveInteger(data.next(1));
        Validator.checkValid(() -> Network.isValid(network), new InvalidNetworkException(network));
        byte[] seed = data.next();
        Validator.checkValidLength(seed, 32);
        return new Seed(seed, Network.valueOf(network), ArrayUtil.toPrimitiveInteger(version));
    }

    public Seed(byte[] seed) throws ValidateException {
        this(seed, GlobalConfiguration.network());
    }

    public Seed(byte[] seed, Network network) throws ValidateException {
        this(seed, network, 1);
    }

    public Seed(byte[] seed, Network network, int version) throws ValidateException {
        Validator.checkValid(() -> seed != null && seed.length == 32 && network != null && version > 0);
        this.seed = seed;
        this.network = network;
        this.version = version;
    }

    public String getEncodedSeed() {
        byte[] network = VarInt.writeUnsignedVarInt(this.network.value());
        byte[] encodedSeedVersion = VarInt.writeUnsignedVarInt(this.version);
        byte[] data = ArrayUtil.concat(MAGIC_NUMBER, encodedSeedVersion, network, this.seed);
        byte[] checksum = ArrayUtil.slice(Sha3256.hash(data), 0, 4);
        byte[] seed = ArrayUtil.concat(data, checksum);
        return Base58.BASE_58.encode(seed);
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getVersion() {
        return this.version;
    }
}

