/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.sdk.error.ValidateException;
import com.bitmark.sdk.utils.Matcher;

public class Validator {
    public static <T> void checkNonNull(T input) {
        if (input == null) {
            throw new ValidateException.NullValueError();
        }
    }

    public static void checkValidString(String input) {
        if (input == null || input.isEmpty()) {
            throw new ValidateException.InvalidString();
        }
    }

    public static void checkValidHex(String input) {
        Validator.checkNonNull(input);
        if (!Matcher.isHex(input)) {
            throw new ValidateException.InvalidHex();
        }
    }

    public static void checkValidLength(byte[] data, int length) {
        if (data == null || data.length != length) {
            throw new ValidateException.InvalidLength(length, data == null ? 0 : data.length);
        }
    }

    public static void checkValidLength(String[] data, int length) {
        if (data == null || data.length != length) {
            throw new ValidateException.InvalidLength(length, data == null ? 0 : data.length);
        }
    }

    public static void checkValid(Specification specification) {
        Validator.checkValid(specification, "Specification is not match");
    }

    public static void checkValid(Specification specification, String message) {
        if (!specification.isSatisfied()) {
            throw new ValidateException(message);
        }
    }

    public static void checkValid(Specification specification, ValidateException exception) {
        if (!specification.isSatisfied()) {
            throw exception;
        }
    }

    public static <T> void checkValid(T data, Specification1<T> specification) {
        Validator.checkValid(data, specification, "Specification is not match");
    }

    public static <T> void checkValid(T data, Specification1<T> specification, String message) {
        if (!specification.isSatisfied(data)) {
            throw new ValidateException(message);
        }
    }

    public static <T> void checkValid(T data, Specification1<T> specification, ValidateException exception) {
        if (!specification.isSatisfied(data)) {
            throw exception;
        }
    }

    public static interface Specification {
        public boolean isSatisfied();
    }

    public static interface Specification1<T> {
        public boolean isSatisfied(T var1);
    }
}

