/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils.error;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.Map;

public class HttpException
extends RuntimeException {
    private int statusCode;
    private int errorCode;
    private String reason;
    private String message;

    public HttpException(int code, String response) {
        super(String.format("A Http Exception has occurred when trying to connect with server. The status code is %d. \n Root cause : %s", code, response));
        this.statusCode = code;
        Map<String, String> jsonMap = this.deserialize(response);
        if (jsonMap != null) {
            this.errorCode = Integer.valueOf(jsonMap.get("code"));
            this.message = jsonMap.get("message");
            this.reason = jsonMap.get("reason");
        } else {
            this.message = response;
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getReason() {
        return this.reason;
    }

    private Map<String, String> deserialize(String response) {
        try {
            return (Map)new GsonBuilder().create().fromJson(response, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }
}

