/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils.record;

import com.bitmark.sdk.utils.record.Head;
import com.bitmark.sdk.utils.record.OfferRecord;
import com.bitmark.sdk.utils.record.Record;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;

public class BitmarkRecord
implements Record {
    @SerializedName(value="asset_id")
    private String assetId;
    @SerializedName(value="block_number")
    private long blockNumber;
    @SerializedName(value="confirmed_at")
    private String confirmedAt;
    @SerializedName(value="created_at")
    private String createdAt;
    private Head head;
    @SerializedName(value="head_id")
    private String headId;
    private String id;
    @SerializedName(value="issued_at")
    private String issuedAt;
    private String issuer;
    private long offset;
    private String owner;
    private Status status;
    private OfferRecord offer;

    public BitmarkRecord(String assetId, long blockNumber, String confirmedAt, String createdAt, Head head, String headId, String id, String issuedAt, String issuer, long offset, String owner, Status status, OfferRecord offer) {
        this.assetId = assetId;
        this.blockNumber = blockNumber;
        this.confirmedAt = confirmedAt;
        this.createdAt = createdAt;
        this.head = head;
        this.headId = headId;
        this.id = id;
        this.issuedAt = issuedAt;
        this.issuer = issuer;
        this.offset = offset;
        this.owner = owner;
        this.status = status;
        this.offer = offer;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public String getConfirmedAt() {
        return this.confirmedAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Head getHead() {
        return this.head;
    }

    public String getHeadId() {
        return this.headId;
    }

    public String getId() {
        return this.id;
    }

    public String getIssuedAt() {
        return this.issuedAt;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getOwner() {
        return this.owner;
    }

    public Status getStatus() {
        return this.status;
    }

    public OfferRecord getOffer() {
        return this.offer;
    }

    public boolean isOffer() {
        return this.offer != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmarkRecord bitmark = (BitmarkRecord)o;
        return this.blockNumber == bitmark.blockNumber && this.offset == bitmark.offset && Objects.equals(this.assetId, bitmark.assetId) && Objects.equals(this.confirmedAt, bitmark.confirmedAt) && Objects.equals(this.createdAt, bitmark.createdAt) && Objects.equals((Object)this.head, (Object)bitmark.head) && Objects.equals(this.headId, bitmark.headId) && Objects.equals(this.id, bitmark.id) && Objects.equals(this.issuedAt, bitmark.issuedAt) && Objects.equals(this.issuer, bitmark.issuer) && Objects.equals(this.owner, bitmark.owner) && this.status == bitmark.status && Objects.equals(this.offer, bitmark.offer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetId, this.blockNumber, this.confirmedAt, this.createdAt, this.head, this.headId, this.id, this.issuedAt, this.issuer, this.offset, this.owner, this.status, this.offer});
    }

    public static enum Status {
        ISSUING,
        TRANSFERRING,
        OFFERING,
        SETTLED;

    }
}

