/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils.record;

import com.bitmark.sdk.crypto.encoder.Hex;
import com.bitmark.sdk.utils.Address;
import com.bitmark.sdk.utils.Validator;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.Objects;

public class OfferRecord
implements com.bitmark.sdk.utils.record.Record {
    private String id;
    private String from;
    private String to;
    private Record record;
    @SerializedName(value="extra_info")
    private Map<String, Object> extraInfo;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="open")
    private boolean isOpen;

    public OfferRecord(String id, String owner, String link, String signature) {
        Validator.checkValidHex(signature);
        Validator.checkValid(() -> id != null && !id.isEmpty() && owner != null && Address.fromAccountNumber(owner).isValid() && link != null && Hex.HEX.decode(link).length == 32, "Invalid params");
        this.id = id;
        this.record = new Record();
        this.record.link = link;
        this.record.signature = signature;
        this.record.owner = owner;
    }

    public String getId() {
        return this.id;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Record getRecord() {
        return this.record;
    }

    public Map<String, Object> getExtraInfo() {
        return this.extraInfo;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String getLink() {
        return this.record == null ? null : this.record.link;
    }

    public String getSignature() {
        return this.record == null ? null : this.record.signature;
    }

    public String getOwner() {
        return this.record != null && this.record.owner != null ? this.record.owner : this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRecord offer = (OfferRecord)o;
        return this.isOpen == offer.isOpen && Objects.equals(this.id, offer.id) && Objects.equals(this.from, offer.from) && Objects.equals(this.to, offer.to) && Objects.equals(this.record, offer.record) && Objects.equals(this.extraInfo, offer.extraInfo) && Objects.equals(this.createdAt, offer.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.from, this.to, this.record, this.extraInfo, this.createdAt, this.isOpen);
    }

    public static final class Record {
        String link;
        String owner;
        String signature;

        public String getLink() {
            return this.link;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return Objects.equals(this.link, record.link) && Objects.equals(this.owner, record.owner) && Objects.equals(this.signature, record.signature);
        }

        public int hashCode() {
            return Objects.hash(this.link, this.owner, this.signature);
        }
    }
}

