/*
 * Decompiled with CFR 0.152.
 */
package sdk.utils;

import apiservice.configuration.GlobalConfiguration;
import apiservice.configuration.Network;
import apiservice.utils.ArrayUtil;
import cryptography.crypto.Random;
import cryptography.error.ValidateException;
import cryptography.utils.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import sdk.utils.Seed;

public class RecoveryPhrase {
    public static final int MNEMONIC_WORD_LENGTH = 24;
    private static final int ENTROPY_LENGTH = 33;
    private final String[] mnemonicWords;
    private static final String[] WORDS = new String[2048];
    private static final int[] MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023};

    public static RecoveryPhrase fromSeed(Seed seed) throws ValidateException {
        Validator.checkValid(() -> seed != null && seed.getSeed().length == 32, (String)"Invalid Seed");
        Network network = seed.getNetwork();
        byte[] seedData = seed.getSeed();
        return new RecoveryPhrase(RecoveryPhrase.generateMnemonic(RecoveryPhrase.getEntropy(network, seedData)));
    }

    public static RecoveryPhrase fromMnemonicWords(String ... mnemonicWords) throws ValidateException {
        return new RecoveryPhrase(mnemonicWords);
    }

    public RecoveryPhrase() {
        byte[] randomBytes = Random.secureRandomBytes((int)32);
        byte[] entropy = RecoveryPhrase.getEntropy(GlobalConfiguration.network(), randomBytes);
        this.mnemonicWords = RecoveryPhrase.generateMnemonic(entropy);
    }

    private RecoveryPhrase(String ... mnemonicWords) throws ValidateException {
        RecoveryPhrase.validate(mnemonicWords);
        this.mnemonicWords = mnemonicWords;
    }

    public String[] getMnemonicWords() {
        return this.mnemonicWords;
    }

    public Seed recoverSeed() {
        return RecoveryPhrase.recoverSeed(this.mnemonicWords);
    }

    public static Seed recoverSeed(String[] mnemonicWord) {
        RecoveryPhrase.validate(mnemonicWord);
        int[] data = new int[]{};
        int remainder = 0;
        int bits = 0;
        for (int i = 0; i < 24; ++i) {
            String word = mnemonicWord[i];
            int index = ArrayUtil.indexOf((String[])WORDS, (String)word);
            remainder = (remainder << 11) + index;
            bits += 11;
            while (bits >= 8) {
                int a = 0xFF & remainder >> bits - 8;
                data = ArrayUtil.concat((int[])data, (int[])new int[]{a});
                bits -= 8;
            }
            remainder &= MASKS[bits];
        }
        byte[] entropy = ArrayUtil.toByteArray((int[])data);
        Validator.checkValid(() -> entropy.length == 33, (String)"Invalid mnemonic words");
        Network network = Network.valueOf((int)entropy[0]);
        byte[] seed = ArrayUtil.slice((byte[])entropy, (int)1, (int)33);
        return new Seed(seed, network);
    }

    public static String[] generateMnemonic(byte[] entropy) throws ValidateException {
        Validator.checkValid(() -> entropy != null && entropy.length == 33, (String)"Invalid entropy length. The valid length must be 33");
        ArrayList<String> mnemonicWords = new ArrayList<String>(24);
        int[] unsignedEntropy = ArrayUtil.toUInt((byte[])entropy);
        int accumulator = 0;
        int bits = 0;
        for (int i = 0; i < 33; ++i) {
            accumulator = (accumulator << 8) + unsignedEntropy[i];
            if ((bits += 8) < 11) continue;
            int index = accumulator >> (bits -= 11);
            accumulator &= MASKS[bits];
            mnemonicWords.add(WORDS[index]);
        }
        return mnemonicWords.toArray(new String[24]);
    }

    private static void validate(String ... mnemonicWords) {
        Validator.checkValid(() -> mnemonicWords != null && mnemonicWords.length == 24 && ArrayUtil.contains((String[])WORDS, (String[])mnemonicWords));
    }

    private static byte[] getEntropy(Network network, byte[] seed) {
        return ArrayUtil.concat((byte[])ArrayUtil.toByteArray((int)network.value()), (byte[])seed);
    }

    static {
        try {
            String word;
            File file = new File(RecoveryPhrase.class.getResource("/bip39_eng.txt").getFile());
            BufferedReader reader = new BufferedReader(new FileReader(file));
            for (int i = 0; i < WORDS.length && (word = reader.readLine()) != null; ++i) {
                RecoveryPhrase.WORDS[i] = word;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

