/*
 * Decompiled with CFR 0.152.
 */
package sdk.utils;

import apiservice.configuration.GlobalConfiguration;
import apiservice.configuration.Network;
import apiservice.utils.ArrayUtil;
import apiservice.utils.error.InvalidNetworkException;
import cryptography.crypto.Sha3256;
import cryptography.crypto.encoder.Base58;
import cryptography.crypto.encoder.Hex;
import cryptography.crypto.encoder.VarInt;
import cryptography.error.ValidateException;
import cryptography.utils.Validator;
import java.util.Arrays;
import sdk.utils.SequenceIterateByteArray;
import sdk.utils.error.InvalidChecksumException;
import sdk.utils.error.InvalidSeedException;

public class Seed {
    public static final int LENGTH = 32;
    public static final int VERSION = 1;
    private static final int ENCODED_LENGTH = 40;
    private static final byte[] MAGIC_NUMBER = Hex.HEX.decode("5AFE");
    private static final int NETWORK_LENGTH = 1;
    private static final int CHECKSUM_LENGTH = 4;
    private byte[] seed;
    private Network network;
    private int version;

    public static Seed fromEncodedSeed(String encodedSeed) throws ValidateException {
        byte[] seedBytes = Base58.BASE_58.decode(encodedSeed);
        Validator.checkValidLength((byte[])seedBytes, (int)40);
        int length = seedBytes.length;
        byte[] checksum = ArrayUtil.slice((byte[])seedBytes, (int)(length - 4), (int)length);
        SequenceIterateByteArray data = new SequenceIterateByteArray(Arrays.copyOfRange(seedBytes, 0, length - 4));
        byte[] dataHashed = Sha3256.hash((byte[])data.getBytes());
        byte[] checksumVerification = ArrayUtil.slice((byte[])dataHashed, (int)0, (int)4);
        Validator.checkValid(() -> Arrays.equals(checksum, checksumVerification), (ValidateException)new InvalidChecksumException(checksumVerification, checksum));
        byte[] magicNumber = data.next(MAGIC_NUMBER.length);
        Validator.checkValid(() -> Arrays.equals(magicNumber, MAGIC_NUMBER), (ValidateException)new InvalidSeedException.InvalidMagicNumberException(magicNumber, MAGIC_NUMBER));
        byte[] encodedSeedVersion = VarInt.writeUnsignedVarInt((int)1);
        byte[] version = data.next(encodedSeedVersion.length);
        Validator.checkValid(() -> Arrays.equals(version, encodedSeedVersion), (ValidateException)new InvalidSeedException.InvalidVersionException(version, encodedSeedVersion));
        int network = ArrayUtil.toPrimitiveInteger((byte[])data.next(1));
        Validator.checkValid(() -> Network.isValid((int)network), (ValidateException)new InvalidNetworkException(network));
        byte[] seed = data.next();
        Validator.checkValidLength((byte[])seed, (int)32);
        return new Seed(seed, Network.valueOf((int)network), ArrayUtil.toPrimitiveInteger((byte[])version));
    }

    public Seed(byte[] seed) throws ValidateException {
        this(seed, GlobalConfiguration.network());
    }

    public Seed(byte[] seed, Network network) throws ValidateException {
        this(seed, network, 1);
    }

    public Seed(byte[] seed, Network network, int version) throws ValidateException {
        Validator.checkValid(() -> seed != null && seed.length == 32 && network != null && version > 0);
        this.seed = seed;
        this.network = network;
        this.version = version;
    }

    public String getEncodedSeed() {
        byte[] network = VarInt.writeUnsignedVarInt((int)this.network.value());
        byte[] encodedSeedVersion = VarInt.writeUnsignedVarInt((int)this.version);
        byte[] data = ArrayUtil.concat((byte[])MAGIC_NUMBER, (byte[])encodedSeedVersion, (byte[])network, (byte[])this.seed);
        byte[] checksum = ArrayUtil.slice((byte[])Sha3256.hash((byte[])data), (int)0, (int)4);
        byte[] seed = ArrayUtil.concat((byte[])data, (byte[])checksum);
        return Base58.BASE_58.encode(seed);
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getVersion() {
        return this.version;
    }
}

