/*
 * Decompiled with CFR 0.152.
 */
package sdk.utils;

import apiservice.utils.ArrayUtil;
import cryptography.utils.Validator;

public class SequenceIterateByteArray {
    private final byte[] bytes;
    private int currentPos;

    public SequenceIterateByteArray(byte[] bytes) {
        Validator.checkNonNull((Object)bytes);
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] next(int length) {
        int endPos;
        Validator.checkValid(() -> length > 0, (String)"Length mush be greater than 0");
        if (this.currentPos + length > this.bytes.length) {
            throw new ArrayIndexOutOfBoundsException("Length is greater than remaining byte array length");
        }
        int startPos = this.currentPos;
        this.currentPos = endPos = startPos + length;
        return ArrayUtil.slice((byte[])this.bytes, (int)startPos, (int)endPos);
    }

    public byte[] next() {
        int remaining = this.bytes.length - this.currentPos;
        return this.next(remaining);
    }
}

