/*
 * Decompiled with CFR 0.152.
 */
package sdk.utils;

import apiservice.configuration.GlobalConfiguration;
import apiservice.utils.ArrayUtil;
import apiservice.utils.error.UnexpectedException;
import cryptography.error.ValidateException;
import cryptography.utils.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import sdk.utils.FileUtils;
import sdk.utils.SdkUtils;
import sdk.utils.Seed;

public class RecoveryPhrase {
    public static final int MNEMONIC_WORD_LENGTH = 12;
    private static final int ENTROPY_LENGTH = 17;
    private final String[] mnemonicWords;
    private static String[] EN_WORDS;
    private static String[] CN_WORDS;
    private static final int[] MASKS;

    private static String[] getWords(Locale locale) {
        Validator.checkValid(() -> locale == Locale.ENGLISH || locale == Locale.CHINESE, (String)"Does not support this locale");
        if (locale == Locale.ENGLISH && EN_WORDS != null) {
            return EN_WORDS;
        }
        if (locale == Locale.CHINESE && CN_WORDS != null) {
            return CN_WORDS;
        }
        try {
            String word;
            int size = 2048;
            File file = FileUtils.getResourceAsFile(locale == Locale.ENGLISH ? "bip/bip39_eng.txt" : "bip/bip39_cn.txt");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String[] words = new String[2048];
            for (int i = 0; i < 2048 && (word = reader.readLine()) != null; ++i) {
                words[i] = word;
            }
            if (locale == Locale.ENGLISH) {
                EN_WORDS = words;
            } else {
                CN_WORDS = words;
            }
            return words;
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage());
        }
    }

    public static RecoveryPhrase fromSeed(Seed seed) throws ValidateException {
        return RecoveryPhrase.fromSeed(seed, Locale.ENGLISH);
    }

    public static RecoveryPhrase fromSeed(Seed seed, Locale locale) throws ValidateException {
        Validator.checkValid(() -> seed != null && seed.getSeed().length == 17, (String)"Invalid Seed");
        return new RecoveryPhrase(RecoveryPhrase.generateMnemonic(seed.getSeed(), locale));
    }

    public static RecoveryPhrase fromMnemonicWords(String ... mnemonicWords) throws ValidateException {
        return new RecoveryPhrase(mnemonicWords);
    }

    public RecoveryPhrase() {
        byte[] entropy = SdkUtils.randomEntropy(GlobalConfiguration.network());
        this.mnemonicWords = RecoveryPhrase.generateMnemonic(entropy);
    }

    private RecoveryPhrase(String ... mnemonicWords) throws ValidateException {
        RecoveryPhrase.validate(mnemonicWords);
        this.mnemonicWords = mnemonicWords;
    }

    public String[] getMnemonicWords() {
        return this.mnemonicWords;
    }

    public Seed recoverSeed() {
        return RecoveryPhrase.recoverSeed(this.mnemonicWords);
    }

    public static Seed recoverSeed(String[] mnemonicWord) throws ValidateException {
        RecoveryPhrase.validate(mnemonicWord);
        Locale locale = RecoveryPhrase.detectLocale(mnemonicWord[0]);
        String[] words = RecoveryPhrase.getWords(locale);
        int[] data = new int[]{};
        int remainder = 0;
        int bits = 0;
        for (int i = 0; i < 12; ++i) {
            String word = mnemonicWord[i];
            int index = ArrayUtil.indexOf((String[])words, (String)word);
            remainder = (remainder << 11) + index;
            bits += 11;
            while (bits >= 8) {
                int a = 0xFF & remainder >> bits - 8;
                data = ArrayUtil.concat((int[])data, (int[])new int[]{a});
                bits -= 8;
            }
            remainder &= MASKS[bits];
        }
        byte[] entropy = ArrayUtil.concat((byte[])ArrayUtil.toByteArray((int[])data), (byte[])new byte[]{(byte)(remainder << 4)});
        Validator.checkValid(() -> entropy.length == 17, (String)"Invalid mnemonic words");
        return new Seed(entropy);
    }

    public static String[] generateMnemonic(byte[] entropy) throws ValidateException {
        return RecoveryPhrase.generateMnemonic(entropy, Locale.ENGLISH);
    }

    public static String[] generateMnemonic(byte[] entropy, Locale locale) throws ValidateException {
        Validator.checkValid(() -> entropy != null && entropy.length == 17, (String)"Invalid entropy length. The valid length must be 17");
        String[] words = RecoveryPhrase.getWords(locale);
        ArrayList<String> mnemonicWords = new ArrayList<String>(12);
        int[] unsignedEntropy = ArrayUtil.toUInt((byte[])entropy);
        int accumulator = 0;
        int bits = 0;
        for (int i = 0; i < 17; ++i) {
            accumulator = (accumulator << 8) + unsignedEntropy[i];
            if ((bits += 8) < 11) continue;
            int index = accumulator >> (bits -= 11);
            accumulator &= MASKS[bits];
            mnemonicWords.add(words[index]);
        }
        return mnemonicWords.toArray(new String[12]);
    }

    private static void validate(String ... mnemonicWords) {
        Validator.checkValid(() -> mnemonicWords != null && mnemonicWords.length == 12 && (ArrayUtil.contains((String[])RecoveryPhrase.getWords(Locale.ENGLISH), (String[])mnemonicWords) || ArrayUtil.contains((String[])RecoveryPhrase.getWords(Locale.CHINESE), (String[])mnemonicWords)));
    }

    private static Locale detectLocale(String examined) {
        String engRegex = "^[a-z]+$";
        String cnRegex = "\\p{IsHan}";
        if (Pattern.compile("^[a-z]+$").matcher(examined).matches()) {
            return Locale.ENGLISH;
        }
        if (Pattern.compile("\\p{IsHan}").matcher(examined).matches()) {
            return Locale.CHINESE;
        }
        throw new ValidateException("Cannot detect your language.");
    }

    static {
        MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023};
    }
}

