/*
 * Decompiled with CFR 0.152.
 */
package sdk.utils;

import apiservice.configuration.Network;
import apiservice.utils.ArrayUtil;
import cryptography.crypto.Sha3256;
import cryptography.crypto.encoder.Base58;
import cryptography.error.ValidateException;
import cryptography.utils.Validator;
import java.util.Arrays;
import sdk.utils.SdkUtils;
import sdk.utils.error.InvalidChecksumException;

public class Seed {
    public static final int SEED_LENGTH = 17;
    private static final byte[] HEADERS = new byte[]{90, -2, 2};
    private static final int CHECKSUM_LENGTH = 4;
    private static final int ENCODED_LENGTH = 17 + HEADERS.length + 4;
    private byte[] seed;
    private Network network;

    public static Seed fromEncodedSeed(String encodedSeed) throws ValidateException {
        byte[] seedBytes = Base58.BASE_58.decode(encodedSeed);
        Validator.checkValidLength((byte[])seedBytes, (int)ENCODED_LENGTH);
        int length = seedBytes.length;
        byte[] checksum = ArrayUtil.slice((byte[])seedBytes, (int)(length - 4), (int)length);
        byte[] data = Arrays.copyOfRange(seedBytes, 0, length - 4);
        byte[] dataHashed = Sha3256.hash((byte[])data);
        byte[] checksumVerification = ArrayUtil.slice((byte[])dataHashed, (int)0, (int)4);
        Validator.checkValid(() -> Arrays.equals(checksum, checksumVerification), (ValidateException)new InvalidChecksumException(checksumVerification, checksum));
        byte[] seed = ArrayUtil.slice((byte[])data, (int)HEADERS.length, (int)data.length);
        Validator.checkValidLength((byte[])seed, (int)17);
        return new Seed(seed);
    }

    public Seed(byte[] seed) throws ValidateException {
        Validator.checkValid(() -> seed != null && seed.length == 17);
        this.seed = seed;
        this.network = SdkUtils.extractNetwork(seed);
    }

    public Seed(byte[] seed, Network network) throws ValidateException {
        Validator.checkValid(() -> seed != null && seed.length == 17 && network != null);
        if (SdkUtils.extractNetwork(seed) != network) {
            throw new ValidateException("Invalid network");
        }
        this.seed = seed;
        this.network = network;
    }

    public String getEncodedSeed() {
        byte[] data = ArrayUtil.concat((byte[])HEADERS, (byte[])this.seed);
        byte[] checksum = ArrayUtil.slice((byte[])Sha3256.hash((byte[])data), (int)0, (int)4);
        byte[] seed = ArrayUtil.concat((byte[])data, (byte[])checksum);
        return Base58.BASE_58.encode(seed);
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Network getNetwork() {
        return this.network;
    }
}

