/*
 * Decompiled with CFR 0.152.
 */
package sdk.features;

import apiservice.configuration.GlobalConfiguration;
import apiservice.configuration.Network;
import apiservice.utils.Address;
import apiservice.utils.ArrayUtil;
import cryptography.crypto.Ed25519;
import cryptography.crypto.Sha3256;
import cryptography.crypto.encoder.Base58;
import cryptography.crypto.key.KeyPair;
import cryptography.crypto.key.PublicKey;
import cryptography.error.ValidateException;
import cryptography.utils.Validator;
import java.util.Locale;
import sdk.utils.AccountNumberData;
import sdk.utils.RecoveryPhrase;
import sdk.utils.SdkUtils;
import sdk.utils.Seed;

public class Account {
    private String accountNumber;
    private byte[] core;

    public static Account fromSeed(Seed seed) throws ValidateException {
        Validator.checkValid(() -> seed.getNetwork() == GlobalConfiguration.network(), (String)"Incorrect network from Seed");
        byte[] core = seed.getSeed();
        KeyPair key = Account.generateKeyPair(core);
        String accountNumber = Account.generateAccountNumber(key.publicKey(), seed.getNetwork());
        return new Account(core, accountNumber);
    }

    public static Account fromRecoveryPhrase(String ... recoveryPhrase) throws ValidateException {
        RecoveryPhrase phrase = RecoveryPhrase.fromMnemonicWords(recoveryPhrase);
        Seed seed = phrase.recoverSeed();
        return Account.fromSeed(seed);
    }

    public Account() {
        this.core = SdkUtils.randomEntropy(GlobalConfiguration.network());
        KeyPair key = Account.generateKeyPair(this.core);
        this.accountNumber = Account.generateAccountNumber(key.publicKey());
    }

    private Account(byte[] core, String accountNumber) {
        this.core = core;
        this.accountNumber = accountNumber;
    }

    public KeyPair getKey() {
        return Account.generateKeyPair(this.core);
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public RecoveryPhrase getRecoveryPhrase() {
        return this.getRecoveryPhrase(Locale.ENGLISH);
    }

    public RecoveryPhrase getRecoveryPhrase(Locale locale) {
        return RecoveryPhrase.fromSeed(this.getSeed(), locale);
    }

    public Seed getSeed() {
        AccountNumberData data = Account.parseAccountNumber(this.accountNumber);
        return new Seed(this.core, data.getNetwork());
    }

    public Address toAddress() {
        return Address.fromAccountNumber((String)this.accountNumber);
    }

    public static boolean isValidAccountNumber(String accountNumber) {
        try {
            Account.parseAccountNumber(accountNumber);
            return true;
        }
        catch (ValidateException ex) {
            return false;
        }
    }

    public static AccountNumberData parseAccountNumber(String accountNumber) {
        Address address = Address.fromAccountNumber((String)accountNumber);
        return AccountNumberData.from(address.getKey(), address.getNetwork());
    }

    private static KeyPair generateKeyPair(byte[] core) {
        byte[] seed = SdkUtils.generateSeedKey(core, 32);
        return Ed25519.generateKeyPairFromSeed((byte[])seed);
    }

    private static String generateAccountNumber(PublicKey key) {
        return Account.generateAccountNumber(key, GlobalConfiguration.network());
    }

    private static String generateAccountNumber(PublicKey key, Network network) {
        Address address = Address.getDefault((PublicKey)key, (Network)network);
        byte[] keyVariantVarInt = address.getPrefix();
        byte[] publicKeyBytes = key.toBytes();
        byte[] preChecksum = ArrayUtil.concat((byte[])keyVariantVarInt, (byte[])publicKeyBytes);
        byte[] checksum = ArrayUtil.slice((byte[])Sha3256.hash((byte[])preChecksum), (int)0, (int)4);
        return Base58.BASE_58.encode(ArrayUtil.concat((byte[])keyVariantVarInt, (byte[])publicKeyBytes, (byte[])checksum));
    }
}

