/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.features;

import com.bitmark.apiservice.configuration.GlobalConfiguration;
import com.bitmark.apiservice.configuration.Network;
import com.bitmark.apiservice.utils.Address;
import com.bitmark.apiservice.utils.ArrayUtil;
import com.bitmark.cryptography.crypto.Ed25519;
import com.bitmark.cryptography.crypto.SecretBox;
import com.bitmark.cryptography.crypto.Sha3256;
import com.bitmark.cryptography.crypto.encoder.Base58;
import com.bitmark.cryptography.crypto.encoder.Hex;
import com.bitmark.cryptography.crypto.key.KeyPair;
import com.bitmark.cryptography.crypto.key.PublicKey;
import com.bitmark.cryptography.error.ValidateException;
import com.bitmark.cryptography.utils.Validator;
import com.bitmark.sdk.features.RecoveryPhrase;
import com.bitmark.sdk.features.Seed;
import com.bitmark.sdk.utils.AccountNumberData;
import com.bitmark.sdk.utils.SdkUtils;
import com.bitmark.sdk.utils.Version;
import java.util.Locale;

public class Account {
    private static final byte[] KEY_INDEX = Hex.HEX.decode("000000000000000000000000000003E7");
    private static final int NONCE_LENGTH = 24;
    private String accountNumber;
    private byte[] core;

    public static Account fromSeed(Seed seed) throws ValidateException {
        Validator.checkValid(() -> seed.getNetwork() == GlobalConfiguration.network(), (String)"Incorrect network from Seed");
        byte[] core = seed.getSeed();
        KeyPair key = Account.generateKeyPair(core);
        String accountNumber = Account.generateAccountNumber(key.publicKey(), seed.getNetwork());
        return new Account(core, accountNumber);
    }

    public static Account fromRecoveryPhrase(String ... recoveryPhrase) throws ValidateException {
        RecoveryPhrase phrase = RecoveryPhrase.fromMnemonicWords(recoveryPhrase);
        Seed seed = phrase.recoverSeed();
        return Account.fromSeed(seed);
    }

    public Account() {
        this.core = SdkUtils.randomEntropy(GlobalConfiguration.network());
        KeyPair key = Account.generateKeyPair(this.core);
        this.accountNumber = Account.generateAccountNumber(key.publicKey());
    }

    private Account(byte[] core, String accountNumber) {
        this.core = core;
        this.accountNumber = accountNumber;
    }

    public KeyPair getKey() {
        return Account.generateKeyPair(this.core);
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public RecoveryPhrase getRecoveryPhrase() {
        return this.getRecoveryPhrase(Locale.ENGLISH);
    }

    public RecoveryPhrase getRecoveryPhrase(Locale locale) {
        return RecoveryPhrase.fromSeed(this.getSeed(), locale);
    }

    public Seed getSeed() {
        AccountNumberData data = Account.parseAccountNumber(this.accountNumber);
        return new Seed(this.core, data.getNetwork());
    }

    public Address toAddress() {
        return Address.fromAccountNumber((String)this.accountNumber);
    }

    public static boolean isValidAccountNumber(String accountNumber) {
        try {
            Account.parseAccountNumber(accountNumber);
            return true;
        }
        catch (ValidateException ex) {
            return false;
        }
    }

    public static AccountNumberData parseAccountNumber(String accountNumber) {
        Address address = Address.fromAccountNumber((String)accountNumber);
        return AccountNumberData.from(address.getKey(), address.getNetwork());
    }

    private static KeyPair generateKeyPair(byte[] core) {
        Version version = Version.fromCore(core);
        byte[] seed = version == Version.TWELVE ? SdkUtils.generateSeedKey(core, 32) : SecretBox.generateSecretBox((byte[])KEY_INDEX, (byte[])new byte[24], (byte[])core);
        return Ed25519.generateKeyPairFromSeed((byte[])seed);
    }

    private static String generateAccountNumber(PublicKey key) {
        return Account.generateAccountNumber(key, GlobalConfiguration.network());
    }

    private static String generateAccountNumber(PublicKey key, Network network) {
        Address address = Address.getDefault((PublicKey)key, (Network)network);
        byte[] keyVariantVarInt = address.getPrefix();
        byte[] publicKeyBytes = key.toBytes();
        byte[] preChecksum = ArrayUtil.concat((byte[])keyVariantVarInt, (byte[])publicKeyBytes);
        byte[] checksum = ArrayUtil.slice((byte[])Sha3256.hash((byte[])preChecksum), (int)0, (int)4);
        return Base58.BASE_58.encode(ArrayUtil.concat((byte[])keyVariantVarInt, (byte[])publicKeyBytes, (byte[])checksum));
    }
}

